/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.common;

import jakarta.annotation.security.RolesAllowed;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;

@ApplicationScoped
public abstract class AbstractHttpResource {
    public static final String PROXIED_URL = "https://repo.maven.apache.org/maven2/org/apache/camel/quarkus/camel-quarkus-%s/maven-metadata.xml";
    public static final String USER_ADMIN = "admin";
    public static final String USER_ADMIN_PASSWORD = "adm1n";
    public static final String USER_NO_ADMIN = "noadmin";
    public static final String USER_NO_ADMIN_PASSWORD = "n0Adm1n";
    @Inject
    protected FluentProducerTemplate producerTemplate;
    @Inject
    protected ConsumerTemplate consumerTemplate;

    @Path(value="/auth/basic/secured")
    @GET
    @RolesAllowed(value={"admin"})
    @Produces(value={"text/plain"})
    public String basicAuth(@QueryParam(value="component") String component) {
        return "Component " + component + " is using basic auth";
    }

    public abstract String httpGet(int var1);

    public abstract String httpPost(int var1, String var2);

    @Path(value="/get-https")
    @GET
    @Produces(value={"text/plain"})
    public String httpsGet(@QueryParam(value="component") String component) {
        return (String)this.producerTemplate.toF("direct:%s-https", new Object[]{component}).withHeader("CamelHttpMethod", (Object)"GET").request(String.class);
    }

    public abstract Response basicAuth(int var1, String var2, String var3);

    public abstract String httpProxy();
}

