/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hl7.it;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.model.v22.message.ADT_A01;
import ca.uhn.hl7v2.parser.Parser;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.hl7.HL7;
import org.apache.camel.model.RouteDefinition;

@ApplicationScoped
public class Hl7Routes
extends RouteBuilder {
    @Inject
    Parser parser;

    public void configure() throws Exception {
        ((RouteDefinition)this.from("netty:tcp://localhost:{{camel.hl7.test-tcp-port}}?sync=true&encoders=#hl7encoder&decoders=#hl7decoder").convertBodyTo(ADT_A01.class)).to("mock:result");
        this.from("direct:validate").unmarshal("hl7DataFormat");
        this.from("direct:validateCustom").unmarshal().hl7(false).marshal().hl7((Object)this.parser);
        ((RouteDefinition)this.from("direct:marshalUnmarshal").unmarshal("hl7DataFormat")).marshal("hl7DataFormat");
        this.from("direct:hl7terser").setHeader("PATIENT_ID", (Expression)HL7.hl7terser((String)"PID-3-1"));
        this.from("direct:hl7terserBean").bean((Object)"terserBean");
        this.from("direct:unmarshalXml").unmarshal("hl7DataFormat");
        ((RouteDefinition)this.from("direct:ack").unmarshal("hl7DataFormat")).transform((Expression)HL7.ack((AcknowledgmentCode)AcknowledgmentCode.CA));
    }
}

