/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hl7.it;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import org.apache.camel.component.hl7.HL7DataFormat;
import org.apache.camel.component.hl7.HL7MLLPNettyDecoderFactory;
import org.apache.camel.component.hl7.HL7MLLPNettyEncoderFactory;
import org.apache.camel.component.hl7.Hl7Terser;
import org.apache.camel.spi.DataFormat;

public class Hl7Producers {
    @ApplicationScoped
    @Named(value="hl7encoder")
    public HL7MLLPNettyEncoderFactory hl7MLLPNettyEncoderFactory() {
        HL7MLLPNettyEncoderFactory factory = new HL7MLLPNettyEncoderFactory();
        factory.setConvertLFtoCR(true);
        return factory;
    }

    @ApplicationScoped
    @Named(value="hl7decoder")
    public HL7MLLPNettyDecoderFactory hl7MLLPNettyDecoderFactory() {
        HL7MLLPNettyDecoderFactory factory = new HL7MLLPNettyDecoderFactory();
        factory.setConvertLFtoCR(true);
        return factory;
    }

    @ApplicationScoped
    @Named
    public DataFormat hl7DataFormat() {
        return new HL7DataFormat();
    }

    @ApplicationScoped
    @Named
    public TerserBean terserBean() {
        return new TerserBean();
    }

    @ApplicationScoped
    @Named
    public Parser parser() {
        ValidationRuleBuilder builder = new ValidationRuleBuilder(){

            protected void configure() {
                this.forVersion(new Version[]{Version.V22}).message("ADT", new String[]{"*"}).terser("PID-2", this.isEqual("00009999"));
            }
        };
        ValidationContext customValidationContext = ValidationContextFactory.fromBuilder((ValidationRuleBuilder)builder);
        DefaultHapiContext customContext = new DefaultHapiContext(customValidationContext);
        return new GenericParser((HapiContext)customContext);
    }

    static class TerserBean {
        TerserBean() {
        }

        public String patientId(@Hl7Terser(value="PID-3-1") String patientId) {
            return patientId;
        }
    }
}

