/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hl7.it;

import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CK;
import ca.uhn.hl7v2.model.v22.datatype.PN;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.message.ADT_A01;
import ca.uhn.hl7v2.model.v22.segment.PID;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;

@Path(value="/hl7")
@ApplicationScoped
public class Hl7Resource {
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/mllp")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public JsonObject mllp(String message) throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        endpoint.expectedMessageCount(1);
        this.producerTemplate.sendBody("netty:tcp://localhost:{{camel.hl7.test-tcp-port}}?sync=true&encoders=#hl7encoder&decoders=#hl7decoder", (Object)message);
        endpoint.assertIsSatisfied(5000L);
        Exchange exchange = (Exchange)endpoint.getExchanges().get(0);
        ADT_A01 result = (ADT_A01)exchange.getMessage().getBody(ADT_A01.class);
        return this.adtToJsonObject(result);
    }

    @Path(value="/marshalUnmarshal")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response marshalUnmarshal(@QueryParam(value="charset") String charset, String message) {
        Response.ResponseBuilder builder = Response.ok();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (charset != null) {
            headers.put("CamelCharsetName", charset);
            builder.header("Content-Type", (Object)("text/plain;" + charset));
        }
        String result = (String)this.producerTemplate.requestBodyAndHeaders("direct:marshalUnmarshal", (Object)message, headers, String.class);
        return builder.entity((Object)result).build();
    }

    @Path(value="/validate")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response validate(String message) {
        Exchange exchange = this.producerTemplate.request("direct:validate", e -> e.getMessage().setBody((Object)message));
        if (exchange.isFailed()) {
            Exception exception = exchange.getException();
            return Response.serverError().entity((Object)exception.getMessage()).build();
        }
        return Response.ok().build();
    }

    @Path(value="/validate/custom")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response validateCustom(String message) {
        Exchange exchange = this.producerTemplate.request("direct:validateCustom", e -> e.getMessage().setBody((Object)message));
        if (exchange.isFailed()) {
            Exception exception = exchange.getException();
            return Response.serverError().entity((Object)exception.getMessage()).build();
        }
        return Response.ok().build();
    }

    @Path(value="/hl7terser")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String hl7terser(String message) {
        Exchange exchange = this.producerTemplate.request("direct:hl7terser", e -> e.getMessage().setBody((Object)message));
        return (String)exchange.getMessage().getHeader("PATIENT_ID", String.class);
    }

    @Path(value="/hl7terser/bean")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String hl7terserBean(String message) {
        return (String)this.producerTemplate.requestBody("direct:hl7terserBean", (Object)message, String.class);
    }

    @Path(value="/xml")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public JsonObject hl7Xml(String messageXml) {
        ADT_A01 result = (ADT_A01)this.producerTemplate.requestBody("direct:unmarshalXml", (Object)messageXml, ADT_A01.class);
        return this.adtToJsonObject(result);
    }

    @Path(value="/ack")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String validateWithAck(String message) {
        return (String)this.producerTemplate.requestBody("direct:ack", (Object)message, String.class);
    }

    @Path(value="/convert/{version}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String convertStringToAdt(@PathParam(value="version") String version, String message) throws ClassNotFoundException {
        String adtClassName = "ca.uhn.hl7v2.model." + version.toLowerCase() + ".message.ADT_A01";
        Class<?> adtClass = Class.forName(adtClassName);
        AbstractMessage result = (AbstractMessage)this.context.getTypeConverter().convertTo(adtClass, (Object)message);
        return result.getMessage().getVersion();
    }

    private JsonObject adtToJsonObject(ADT_A01 result) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        PID pid = result.getPID();
        PN patientName = pid.getPatientName();
        objectBuilder.add("first_name", patientName.getGivenName().getValue());
        objectBuilder.add("last_name", patientName.getFamilyName().getValue());
        ST birthPlace = pid.getBirthPlace();
        objectBuilder.add("birth_place", birthPlace.getValue());
        CK patientAccountNumber = pid.getPatientAccountNumber();
        objectBuilder.add("account_number", patientAccountNumber.getIDNumber().getValue());
        AD patientAddress = pid.getPatientAddress(0);
        objectBuilder.add("street", patientAddress.getAd1_StreetAddress().getValue());
        objectBuilder.add("city", patientAddress.getAd3_City().getValue());
        objectBuilder.add("zip", patientAddress.getZipOrPostalCode().getValue());
        TN phoneNumber = pid.getPhoneNumberHome(0);
        objectBuilder.add("phone", phoneNumber.getValue());
        return objectBuilder.build();
    }
}

