/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hl7.it;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.UnexpectedSegmentBehaviourEnum;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.camel.quarkus.component.hl7.it.Hl7TestResource;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=Hl7TestResource.class)
class Hl7Test {
    private static final String PID_MESSAGE = Hl7Test.readPidFile();

    Hl7Test() {
    }

    @Test
    public void nettyMllp() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(PID_MESSAGE).post("/hl7/mllp", new Object[0])).then()).statusCode(200)).body("first_name", Matchers.is((Object)"JOHN"), new Object[]{"last_name", Matchers.is((Object)"SMITH"), "birth_place", Matchers.is((Object)"SA"), "account_number", Matchers.is((Object)"0000444444"), "street", Matchers.is((Object)"564 SPRING ST"), "city", Matchers.is((Object)"NEEDHAM"), "zip", Matchers.is((Object)"02494"), "phone", Matchers.is((Object)"(818)565-1551")});
    }

    @Test
    public void hl7DataFormatMarshalUnmarshal() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(PID_MESSAGE).post("/hl7/marshalUnmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)PID_MESSAGE.replace("\n", "\r")), new Matcher[0]);
    }

    @Test
    public void hl7Terser() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(PID_MESSAGE).post("/hl7/hl7terser", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"00001122"), new Matcher[0]);
    }

    @Test
    public void hl7TerserBean() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(PID_MESSAGE).post("/hl7/hl7terser/bean", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"00001122"), new Matcher[0]);
    }

    @Test
    public void hl7Validate() {
        String message = PID_MESSAGE.replace("\r", "\t");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/hl7/validate", new Object[0])).then()).statusCode(500)).body(Matchers.endsWith((String)"PID is not recognized"), new Matcher[0]);
    }

    @Test
    public void hl7ValidateCustomParser() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(PID_MESSAGE).post("/hl7/validate/custom", new Object[0])).then()).statusCode(500)).body(Matchers.is((Object)"Validation failed:  '00009874' requires to be equal to 00009999 at PID-2(0)-1-1"), new Matcher[0]);
    }

    @Test
    public void hl7Xml() throws HL7Exception {
        ValidationContext validationContext = ValidationContextFactory.noValidation();
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setDefaultObx2Type("ST");
        parserConfiguration.setInvalidObx2Type("ST");
        parserConfiguration.setUnexpectedSegmentBehaviour(UnexpectedSegmentBehaviourEnum.ADD_INLINE);
        DefaultHapiContext context = new DefaultHapiContext(parserConfiguration, validationContext, (ModelClassFactory)new DefaultModelClassFactory());
        GenericParser parser = context.getGenericParser();
        Message msg = parser.parse(PID_MESSAGE);
        String xml = parser.encode(msg, "XML");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/hl7/xml", new Object[0])).then()).statusCode(200)).body("first_name", Matchers.is((Object)"JOHN"), new Object[]{"last_name", Matchers.is((Object)"SMITH"), "birth_place", Matchers.is((Object)"SA"), "account_number", Matchers.is((Object)"0000444444"), "street", Matchers.is((Object)"564 SPRING ST"), "city", Matchers.is((Object)"NEEDHAM"), "zip", Matchers.is((Object)"02494"), "phone", Matchers.is((Object)"(818)565-1551")});
    }

    @Test
    public void testGetEncodingFromPid() {
        String[] pidParts = PID_MESSAGE.split("\r");
        String header = pidParts[0] + "||||||ISO-8859-1";
        String pid = pidParts[1].replace("JOHN", "J\u00d6HN").replace("SMITH", "SM\u00cfTH");
        String message = header + "\r" + pid;
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/hl7/marshalUnmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"SM\u00c3\u008fTH^J\u00c3\u0096HN^M"), new Matcher[0]);
        message = pidParts[0] + "||||||UTF-8\r" + pid;
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/hl7/marshalUnmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"SM\u00cfTH^J\u00d6HN^M"), new Matcher[0]);
    }

    @Test
    public void testGetEncodingFromHeader() {
        String message = PID_MESSAGE.replace("JOHN", "J\u00d6HN").replace("SMITH", "SM\u00cfTH");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("charset", new Object[]{"US-ASCII"}).body(message).post("/hl7/marshalUnmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"SM?TH^J?HN^M"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("charset", new Object[]{"UTF-8"}).body(message).post("/hl7/marshalUnmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"SM\u00cfTH^J\u00d6HN^M"), new Matcher[0]);
    }

    @Test
    public void hl7CustomAck() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(PID_MESSAGE).post("/hl7/ack", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"MSA|CA"), new Matcher[0]);
    }

    private static final String readPidFile() {
        try {
            String pidContent = IOUtils.toString((InputStream)Hl7Test.class.getResourceAsStream("/hl7-2.2-pid.txt"), (Charset)StandardCharsets.UTF_8);
            return pidContent.replace("\n", "\r");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

