/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.headersmap.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.headersmap.FastHeadersMapFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class HeadersmapTest {
    HeadersmapTest() {
    }

    @Test
    public void fastHeadersMapFactoryIsConfigured() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/headersmap/get", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @Test
    public void testLookupCaseAgnostic() {
        Map map = new FastHeadersMapFactory().newMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "bar");
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals((Object)"bar", map.get("Foo"));
        Assertions.assertEquals((Object)"bar", map.get("FOO"));
    }

    @Test
    public void testConstructFromOther() {
        Map other = new FastHeadersMapFactory().newMap();
        other.put("Foo", "bar");
        other.put("other", 123);
        Map map = new FastHeadersMapFactory().newMap(other);
        Assertions.assertEquals((Object)"bar", map.get("FOO"));
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals((Object)"bar", map.get("Foo"));
        Assertions.assertEquals((Object)123, map.get("OTHER"));
        Assertions.assertEquals((Object)123, map.get("other"));
        Assertions.assertEquals((Object)123, map.get("OthEr"));
    }

    @Test
    public void testIsInstance() {
        Map map = new FastHeadersMapFactory().newMap();
        Map other = new FastHeadersMapFactory().newMap(map);
        other.put("Foo", "bar");
        other.put("other", 123);
        Assertions.assertTrue((boolean)new FastHeadersMapFactory().isInstanceOf(map));
        Assertions.assertTrue((boolean)new FastHeadersMapFactory().isInstanceOf(other));
        Assertions.assertFalse((boolean)new FastHeadersMapFactory().isInstanceOf(new HashMap()));
    }
}

