/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hbase.it;

import java.net.URI;
import java.util.LinkedHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.hbase.HBaseAttribute;
import org.apache.camel.component.hbase.model.HBaseData;

@Path(value="/hbase")
@ApplicationScoped
public class HbaseResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/get/{table}")
    @GET
    @Produces(value={"application/json"})
    public HBaseData get(@PathParam(value="table") String table) {
        return (HBaseData)this.consumerTemplate.receiveBody("hbase://" + table, 5000L, HBaseData.class);
    }

    @Path(value="/put/{table}/{id}/{family}/{column}")
    @POST
    @Produces(value={"text/plain"})
    public Response put(String body, @PathParam(value="table") String table, @PathParam(value="id") String id, @PathParam(value="family") String family, @PathParam(value="column") String column) throws Exception {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HBaseAttribute.HBASE_ROW_ID.asHeader(), id);
        headers.put(HBaseAttribute.HBASE_FAMILY.asHeader(), family);
        headers.put(HBaseAttribute.HBASE_QUALIFIER.asHeader(), column);
        headers.put(HBaseAttribute.HBASE_VALUE.asHeader(), body);
        headers.put("CamelHBaseOperation", "CamelHBasePut");
        this.producerTemplate.sendBodyAndHeaders("hbase://" + table, null, headers);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

