/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm;
import org.apache.camel.component.grpc.auth.jwt.JwtCallCredentials;
import org.apache.camel.component.grpc.auth.jwt.JwtHelper;
import org.apache.camel.quarkus.component.grpc.it.GrpcServerTestResource;
import org.apache.camel.quarkus.component.grpc.it.model.PingPongGrpc;
import org.apache.camel.quarkus.component.grpc.it.model.PingRequest;
import org.apache.camel.quarkus.component.grpc.it.model.PongResponse;
import org.apache.camel.util.StringHelper;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@QuarkusTest
@QuarkusTestResource(value=GrpcServerTestResource.class)
class GrpcTest {
    private static final String GRPC_TEST_PING_VALUE = "PING";
    private static final int GRPC_TEST_PING_ID = 1234;

    GrpcTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"producerMethodPorts"})
    public void produceAndConsume(String methodName, String portPropertyPlaceholder) {
        boolean synchronous = methodName.startsWith("pingSync");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("portPropertyPlaceholder", new Object[]{portPropertyPlaceholder}).queryParam("pingId", new Object[]{1234}).queryParam("pingName", new Object[]{GRPC_TEST_PING_VALUE}).queryParam("methodName", new Object[]{methodName}).queryParam("synchronous", new Object[]{synchronous}).body(GRPC_TEST_PING_VALUE).post("/grpc/producer", new Object[0])).then()).statusCode(200)).body("pongName", Matchers.equalTo((Object)"PING PONG"), new Object[]{"pongId", Matchers.equalTo((Object)1334)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void consumerExceptionSync() {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.server.exception.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongBlockingStub blockingStub = PingPongGrpc.newBlockingStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            Assertions.assertThrows(StatusRuntimeException.class, () -> blockingStub.pingSyncSync(pingRequest));
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void consumerExceptionAsync() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.server.exception.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongStub pingPongStub = PingPongGrpc.newStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            CountDownLatch latch = new CountDownLatch(1);
            PongResponseStreamObserver observer = new PongResponseStreamObserver(latch);
            pingPongStub.pingSyncAsync(pingRequest, (StreamObserver)observer);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forwardOnComplete() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.forward.completed.server.port", Integer.class);
        CountDownLatch latch = new CountDownLatch(1);
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
        try {
            PingPongGrpc.PingPongStub pingPongStub = PingPongGrpc.newStub((Channel)channel);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = pingPongStub.pingAsyncAsync((StreamObserver)responseObserver);
            requestObserver.onCompleted();
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
                JsonPath json = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/grpc/forwardOnCompleted", (Object[])new Object[0]).then()).statusCode(200)).extract().body().jsonPath();
                String eventType = json.getString("CamelGrpcEventType");
                String methodName = json.getString("CamelGrpcMethodName");
                return eventType != null && eventType.equals("onCompleted") && methodName != null && methodName.equals("pingAsyncAsync");
            });
        }
        finally {
            channel.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled(value="https://github.com/apache/camel-quarkus/issues/3037")
    @Test
    public void forwardOnError() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.forward.error.server.port", Integer.class);
        CountDownLatch latch = new CountDownLatch(1);
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
        try {
            PingPongGrpc.PingPongStub pingPongStub = PingPongGrpc.newStub((Channel)channel);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch, true);
            StreamObserver requestObserver = pingPongStub.pingAsyncAsync((StreamObserver)responseObserver);
            requestObserver.onNext(null);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Assertions.assertNotNull((Object)responseObserver.getErrorResponse());
            Assertions.assertEquals((Object)StatusRuntimeException.class.getName(), (Object)responseObserver.getErrorResponse().getClass().getName());
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
                JsonPath json = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/grpc/forwardOnError", (Object[])new Object[0]).then()).statusCode(200)).extract().body().jsonPath();
                String eventType = json.getString("CamelGrpcEventType");
                String methodName = json.getString("CamelGrpcMethodName");
                String error = json.getString("error");
                return error != null && error.equals(StatusRuntimeException.class.getName()) && eventType != null && eventType.equals("onError") && methodName != null && methodName.equals("pingAsyncAsync");
            });
        }
        finally {
            channel.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void routeControlledStreamObserver() {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.route.controlled.server.port", Integer.class);
        PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
            PingPongGrpc.PingPongBlockingStub blockingStub = PingPongGrpc.newBlockingStub((Channel)channel);
            PongResponse pongResponse = blockingStub.pingSyncSync(pingRequest);
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    @Test
    public void streamReplies() {
        ((ValidatableResponse)RestAssured.get((String)"/grpc/grpcStreamReplies", (Object[])new Object[0]).then()).statusCode(204);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tlsConsumer() throws Exception {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.tls.server.port", Integer.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ManagedChannel channel = null;
        try {
            channel = NettyChannelBuilder.forAddress((String)"localhost", (int)port).sslContext(GrpcSslContexts.forClient().keyManager(classLoader.getResourceAsStream("certs/client.pem"), classLoader.getResourceAsStream("certs/client.key")).trustManager(classLoader.getResourceAsStream("certs/ca.pem")).build()).build();
            PingPongGrpc.PingPongStub pingPongStub = PingPongGrpc.newStub((Channel)channel);
            CountDownLatch latch = new CountDownLatch(1);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = pingPongStub.pingAsyncSync((StreamObserver)responseObserver);
            requestObserver.onNext((Object)pingRequest);
            requestObserver.onCompleted();
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
                JsonPath json = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/grpc/tls", (Object[])new Object[0]).then()).statusCode(200)).extract().body().jsonPath();
                String eventType = json.getString("CamelGrpcEventType");
                String methodName = json.getString("CamelGrpcMethodName");
                return eventType != null && eventType.equals("onNext") && methodName != null && methodName.equals("pingAsyncSync");
            });
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    @Test
    public void tlsProducer() {
        String message = "PING TLS producer";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/grpc/tls", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)(message + " PONG")), new Matcher[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jwtConsumer() throws Exception {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.jwt.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = NettyChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
            String jwtToken = JwtHelper.createJwtToken((JwtAlgorithm)JwtAlgorithm.HMAC256, (String)"camel-quarkus-grpc-secret", null, null);
            PingPongGrpc.PingPongStub pingPongStub = (PingPongGrpc.PingPongStub)PingPongGrpc.newStub((Channel)channel).withCallCredentials((CallCredentials)new JwtCallCredentials(jwtToken));
            CountDownLatch latch = new CountDownLatch(1);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = pingPongStub.pingAsyncSync((StreamObserver)responseObserver);
            requestObserver.onNext((Object)pingRequest);
            requestObserver.onCompleted();
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
                JsonPath json = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/grpc/jwt", (Object[])new Object[0]).then()).statusCode(200)).extract().body().jsonPath();
                String eventType = json.getString("CamelGrpcEventType");
                String methodName = json.getString("CamelGrpcMethodName");
                return eventType != null && eventType.equals("onNext") && methodName != null && methodName.equals("pingAsyncSync");
            });
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    @Test
    public void jwtProducer() {
        String message = "PING JWT producer";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/grpc/jwt", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)(message + " PONG")), new Matcher[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregationConsumerStrategySyncSyncMethodInSync() {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.sync.aggregation.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongBlockingStub blockingStub = PingPongGrpc.newBlockingStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            PongResponse pongResponse = blockingStub.pingSyncSync(pingRequest);
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregationConsumerStrategySyncAsyncMethodInSync() {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.sync.aggregation.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongBlockingStub blockingStub = PingPongGrpc.newBlockingStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            Iterator pongResponseIter = blockingStub.pingSyncAsync(pingRequest);
            while (pongResponseIter.hasNext()) {
                PongResponse pongResponse = (PongResponse)pongResponseIter.next();
                Assertions.assertNotNull((Object)pongResponse);
                Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
                Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
            }
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregationConsumerStrategySyncSyncMethodInAsync() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.sync.aggregation.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongStub nonBlockingStub = PingPongGrpc.newStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            CountDownLatch latch = new CountDownLatch(1);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            nonBlockingStub.pingSyncSync(pingRequest, (StreamObserver)responseObserver);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregationConsumerStrategySyncAsyncMethodInAsync() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.sync.aggregation.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongStub nonBlockingStub = PingPongGrpc.newStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            CountDownLatch latch = new CountDownLatch(1);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            nonBlockingStub.pingSyncAsync(pingRequest, (StreamObserver)responseObserver);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregationConsumerStrategyAsyncSyncMethodInAsync() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.async.aggregation.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongStub asyncNonBlockingStub = PingPongGrpc.newStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            CountDownLatch latch = new CountDownLatch(1);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = asyncNonBlockingStub.pingAsyncSync((StreamObserver)responseObserver);
            requestObserver.onNext((Object)pingRequest);
            requestObserver.onNext((Object)pingRequest);
            requestObserver.onCompleted();
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregationConsumerStrategyAsyncAsyncMethodInAsync() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.async.aggregation.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongStub asyncNonBlockingStub = PingPongGrpc.newStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(1234).build();
            CountDownLatch latch = new CountDownLatch(1);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = asyncNonBlockingStub.pingAsyncAsync((StreamObserver)responseObserver);
            requestObserver.onNext((Object)pingRequest);
            requestObserver.onNext((Object)pingRequest);
            requestObserver.onCompleted();
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)1234, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"generatedProtoClassNames"})
    public void codeGenDependencyScan(String generatedClassPackage) {
        block3: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String packageChar = StringHelper.after((String)generatedClassPackage, (String)"org.acme.proto.").replaceAll(".sub|.dir", "");
            String generatedClassName = generatedClassPackage + ".PingPongProto" + packageChar.toUpperCase();
            try {
                classLoader.loadClass(generatedClassName);
                if (packageChar.equals("d")) {
                    Assertions.fail((String)("Expected to not be able to load generated class: " + generatedClassName));
                }
            }
            catch (ClassNotFoundException e) {
                if (packageChar.equals("d")) break block3;
                Assertions.fail((String)("Expected to be able to load generated class: " + generatedClassName));
            }
        }
    }

    static Stream<Arguments> producerMethodPorts() {
        return Stream.of(Arguments.of((Object[])new Object[]{"pingSyncSync", "{{camel.grpc.test.async.server.port}}"}), Arguments.of((Object[])new Object[]{"pingSyncAsync", "{{camel.grpc.test.async.server.port}}"}), Arguments.of((Object[])new Object[]{"pingAsyncAsync", "{{camel.grpc.test.async.server.port}}"}), Arguments.of((Object[])new Object[]{"pingSyncSync", "{{camel.grpc.test.sync.server.port}}"}), Arguments.of((Object[])new Object[]{"pingSyncAsync", "{{camel.grpc.test.sync.server.port}}"}), Arguments.of((Object[])new Object[]{"pingAsyncAsync", "{{camel.grpc.test.sync.server.port}}"}));
    }

    static List<String> generatedProtoClassNames() {
        String packagePrefix = "org.acme.proto.";
        return List.of(packagePrefix + "a", packagePrefix + "b", packagePrefix + "c", packagePrefix + "c.sub", packagePrefix + "c.sub.dir", packagePrefix + "d", packagePrefix + "d.sub", packagePrefix + "d.sub.dir", packagePrefix + "e");
    }

    static final class PongResponseStreamObserver
    implements StreamObserver<PongResponse> {
        private final CountDownLatch latch;
        private final boolean simulateError;
        private PongResponse pongResponse;
        private Throwable errorResponse;

        public PongResponseStreamObserver(CountDownLatch latch) {
            this(latch, false);
        }

        public PongResponseStreamObserver(CountDownLatch latch, boolean simulateError) {
            this.latch = latch;
            this.simulateError = simulateError;
        }

        public PongResponse getPongResponse() {
            return this.pongResponse;
        }

        public Throwable getErrorResponse() {
            return this.errorResponse;
        }

        public void onNext(PongResponse value) {
            this.pongResponse = value;
            if (this.simulateError) {
                throw new IllegalStateException("Forced exception");
            }
        }

        public void onError(Throwable t) {
            this.latch.countDown();
            this.errorResponse = t;
        }

        public void onCompleted() {
            this.latch.countDown();
        }
    }
}

