/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.quarkus.component.grpc.it.PingPongImpl;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServerTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcServerTestResource.class);
    private Server grpcServer;

    public Map<String, String> start() {
        try {
            Map config = AvailablePortFinder.reserveNetworkPorts(Objects::toString, (String[])new String[]{"grpc.test.server.port", "camel.grpc.test.server.port", "camel.grpc.test.forward.completed.server.port", "camel.grpc.test.forward.error.server.port", "camel.grpc.test.route.controlled.server.port", "camel.grpc.test.tls.server.port", "camel.grpc.test.jwt.server.port"});
            String port = (String)config.get("grpc.test.server.port");
            this.grpcServer = ServerBuilder.forPort((int)Integer.parseInt(port)).addService((BindableService)new PingPongImpl()).build().start();
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start gRPC server", e);
        }
    }

    public void stop() {
        try {
            if (this.grpcServer != null) {
                this.grpcServer.shutdown();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not stop gRPC server", (Throwable)e);
        }
        AvailablePortFinder.releaseReservedPorts();
    }
}

