/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm;
import org.apache.camel.component.grpc.auth.jwt.JwtCallCredentials;
import org.apache.camel.component.grpc.auth.jwt.JwtHelper;
import org.apache.camel.quarkus.component.grpc.it.GrpcServerTestResource;
import org.apache.camel.quarkus.component.grpc.it.model.PingPongGrpc;
import org.apache.camel.quarkus.component.grpc.it.model.PingRequest;
import org.apache.camel.quarkus.component.grpc.it.model.PongResponse;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=GrpcServerTestResource.class)
class GrpcTest {
    private static final String GRPC_TEST_PING_VALUE = "PING";
    private static final int GRPC_TEST_PING_ID = 567;

    GrpcTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void consumer() {
        Config config = ConfigProvider.getConfig();
        Integer camelGrpcPort = (Integer)config.getValue("camel.grpc.test.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)camelGrpcPort).usePlaintext().build();
            PingPongGrpc.PingPongBlockingStub blockingStub = PingPongGrpc.newBlockingStub((Channel)channel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(567).build();
            PongResponse pongResponse = blockingStub.pingSyncSync(pingRequest);
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)567, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    @Test
    public void producer() {
        int id = 1234;
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("text/plain").queryParam("pingId", new Object[]{id}).body(GRPC_TEST_PING_VALUE).post("/grpc/producer", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"PINGPONG"), new Matcher[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forwardOnComplete() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.forward.completed.server.port", Integer.class);
        CountDownLatch latch = new CountDownLatch(1);
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
        try {
            PingPongGrpc.PingPongStub pingPongStub = PingPongGrpc.newStub((Channel)channel);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = pingPongStub.pingAsyncAsync((StreamObserver)responseObserver);
            requestObserver.onCompleted();
            latch.await(5L, TimeUnit.SECONDS);
            ((ValidatableResponse)RestAssured.get((String)"/grpc/forwardOnCompleted", (Object[])new Object[0]).then()).statusCode(204);
        }
        finally {
            channel.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forwardOnError() throws InterruptedException {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.forward.error.server.port", Integer.class);
        CountDownLatch latch = new CountDownLatch(1);
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
        try {
            PingPongGrpc.PingPongStub pingPongStub = PingPongGrpc.newStub((Channel)channel);
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch, true);
            StreamObserver requestObserver = pingPongStub.pingAsyncAsync((StreamObserver)responseObserver);
            requestObserver.onNext(null);
            latch.await(5L, TimeUnit.SECONDS);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/grpc/forwardOnError", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)StatusRuntimeException.class.getName()), new Matcher[0]);
        }
        finally {
            channel.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void routeControlledStreamObserver() {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.route.controlled.server.port", Integer.class);
        PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(567).build();
        ManagedChannel channel = null;
        try {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
            PingPongGrpc.PingPongBlockingStub blockingStub = PingPongGrpc.newBlockingStub((Channel)channel);
            PongResponse pongResponse = blockingStub.pingSyncSync(pingRequest);
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)567, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdownNow();
            }
        }
    }

    @Test
    public void streamReplies() {
        ((ValidatableResponse)RestAssured.get((String)"/grpc/grpcStreamReplies", (Object[])new Object[0]).then()).statusCode(204);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tlsConsumer() throws Exception {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.tls.server.port", Integer.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ManagedChannel channel = null;
        try {
            channel = NettyChannelBuilder.forAddress((String)"localhost", (int)port).sslContext(GrpcSslContexts.forClient().keyManager(classLoader.getResourceAsStream("certs/client.pem"), classLoader.getResourceAsStream("certs/client.key")).trustManager(classLoader.getResourceAsStream("certs/ca.pem")).build()).build();
            PingPongGrpc.PingPongStub pingPongStub = PingPongGrpc.newStub((Channel)channel);
            CountDownLatch latch = new CountDownLatch(1);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(567).build();
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = pingPongStub.pingAsyncSync((StreamObserver)responseObserver);
            requestObserver.onNext((Object)pingRequest);
            latch.await(5L, TimeUnit.SECONDS);
            ((ValidatableResponse)RestAssured.get((String)"/grpc/tls", (Object[])new Object[0]).then()).statusCode(204);
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)567, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    @Test
    public void tlsProducer() {
        String message = "PING TLS";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/grpc/tls", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)(message + " PONG")), new Matcher[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jwtConsumer() throws Exception {
        Config config = ConfigProvider.getConfig();
        Integer port = (Integer)config.getValue("camel.grpc.test.jwt.server.port", Integer.class);
        ManagedChannel channel = null;
        try {
            channel = NettyChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
            String jwtToken = JwtHelper.createJwtToken((JwtAlgorithm)JwtAlgorithm.HMAC256, (String)"camel-quarkus-grpc-secret", null, null);
            PingPongGrpc.PingPongStub pingPongStub = (PingPongGrpc.PingPongStub)PingPongGrpc.newStub((Channel)channel).withCallCredentials((CallCredentials)new JwtCallCredentials(jwtToken));
            CountDownLatch latch = new CountDownLatch(1);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(GRPC_TEST_PING_VALUE).setPingId(567).build();
            PongResponseStreamObserver responseObserver = new PongResponseStreamObserver(latch);
            StreamObserver requestObserver = pingPongStub.pingAsyncSync((StreamObserver)responseObserver);
            requestObserver.onNext((Object)pingRequest);
            latch.await(5L, TimeUnit.SECONDS);
            ((ValidatableResponse)RestAssured.get((String)"/grpc/jwt", (Object[])new Object[0]).then()).statusCode(204);
            PongResponse pongResponse = responseObserver.getPongResponse();
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)567, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"PING PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    @Test
    public void jwtProducer() {
        String message = "PING JWT";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/grpc/jwt", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)(message + " PONG")), new Matcher[0]);
    }

    static final class PongResponseStreamObserver
    implements StreamObserver<PongResponse> {
        private PongResponse pongResponse;
        private final CountDownLatch latch;
        private final boolean simulateError;

        public PongResponseStreamObserver(CountDownLatch latch) {
            this(latch, false);
        }

        public PongResponseStreamObserver(CountDownLatch latch, boolean simulateError) {
            this.latch = latch;
            this.simulateError = simulateError;
        }

        public PongResponse getPongResponse() {
            return this.pongResponse;
        }

        public void onNext(PongResponse value) {
            this.latch.countDown();
            this.pongResponse = value;
            if (this.simulateError) {
                throw new IllegalStateException("Forced exception");
            }
        }

        public void onError(Throwable t) {
            this.latch.countDown();
        }

        public void onCompleted() {
            this.latch.countDown();
        }
    }
}

