/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.grpc.it.model.PingRequest;
import org.apache.camel.quarkus.component.grpc.it.model.PongResponse;

@Path(value="/grpc")
@ApplicationScoped
public class GrpcResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/producer")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String producer(String pingName, @QueryParam(value="pingId") int pingId) throws Exception {
        PingRequest pingRequest = PingRequest.newBuilder().setPingName(pingName).setPingId(pingId).build();
        PongResponse response = (PongResponse)this.producerTemplate.requestBody("grpc://localhost:{{grpc.test.server.port}}/org.apache.camel.quarkus.component.grpc.it.model.PingPong?method=pingSyncSync&synchronous=true", (Object)pingRequest, PongResponse.class);
        return response.getPongName();
    }

    @Path(value="/forwardOnCompleted")
    @GET
    public void forwardOnCompleted() throws InterruptedException {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:forwardOnCompleted", MockEndpoint.class);
        endpoint.expectedMessageCount(1);
        endpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcEventType", new Object[]{"onCompleted"});
        endpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcMethodName", new Object[]{"pingAsyncAsync"});
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/forwardOnError")
    @GET
    public String forwardOnError() throws InterruptedException {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:forwardOnError", MockEndpoint.class);
        endpoint.expectedMessageCount(1);
        endpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcEventType", new Object[]{"onError"});
        endpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcMethodName", new Object[]{"pingAsyncAsync"});
        endpoint.assertIsSatisfied(5000L);
        List exchanges = endpoint.getExchanges();
        Exchange exchange = (Exchange)exchanges.get(0);
        Throwable throwable = (Throwable)exchange.getMessage().getBody(Throwable.class);
        return throwable.getClass().getName();
    }

    @Path(value="/grpcStreamReplies")
    @GET
    public void grpcStreamReplies() throws InterruptedException {
        int messageCount = 10;
        for (int i = 1; i <= messageCount; ++i) {
            PingRequest request = PingRequest.newBuilder().setPingName(String.valueOf(i)).build();
            this.producerTemplate.sendBody("direct:grpcStream", (Object)request);
        }
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:grpcStreamReplies", MockEndpoint.class);
        endpoint.expectedMessageCount(messageCount);
        endpoint.assertIsSatisfied();
    }

    @Path(value="/tls")
    @GET
    public void tlsConsumer() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:tls", MockEndpoint.class);
        mockEndpoint.expectedMessageCount(1);
        mockEndpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcEventType", new Object[]{"onNext"});
        mockEndpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcMethodName", new Object[]{"pingAsyncSync"});
        mockEndpoint.assertIsSatisfied();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/tls")
    @POST
    @Produces(value={"text/plain"})
    public String tlsProducer(String message) {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:tls", MockEndpoint.class);
        try {
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(message).setPingId(12345).build();
            PongResponse response = (PongResponse)this.producerTemplate.requestBody("direct:sendTls", (Object)pingRequest, PongResponse.class);
            String string = response.getPongName();
            return string;
        }
        finally {
            mockEndpoint.reset();
        }
    }

    @Path(value="/jwt")
    @GET
    public void jwtConsumer() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:jwt", MockEndpoint.class);
        mockEndpoint.expectedMessageCount(1);
        mockEndpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcEventType", new Object[]{"onNext"});
        mockEndpoint.expectedHeaderValuesReceivedInAnyOrder("CamelGrpcMethodName", new Object[]{"pingAsyncSync"});
        mockEndpoint.assertIsSatisfied();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/jwt")
    @POST
    @Produces(value={"text/plain"})
    public String jwtProducer(String message) {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:jwt", MockEndpoint.class);
        try {
            PingRequest pingRequest = PingRequest.newBuilder().setPingName(message).setPingId(12345).build();
            PongResponse response = (PongResponse)this.producerTemplate.requestBody("direct:sendJwt", (Object)pingRequest, PongResponse.class);
            String string = response.getPongName();
            return string;
        }
        finally {
            mockEndpoint.reset();
        }
    }
}

