/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import io.grpc.stub.StreamObserver;
import io.quarkus.runtime.annotations.RegisterForReflection;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.grpc.it.model.PingRequest;
import org.apache.camel.quarkus.component.grpc.it.model.PongResponse;

public class GrpcRoute
extends RouteBuilder {
    public static final String GRPC_JWT_SECRET = "camel-quarkus-grpc-secret";
    public static final String PING_PONG_SERVICE = "org.apache.camel.quarkus.component.grpc.it.model.PingPong";

    public void configure() throws Exception {
        this.fromF("grpc://localhost:{{camel.grpc.test.server.port}}/%s?synchronous=true", new Object[]{PING_PONG_SERVICE}).process(exchange -> {
            Message message = exchange.getMessage();
            PingRequest request = (PingRequest)message.getBody(PingRequest.class);
            PongResponse response = PongResponse.newBuilder().setPongName(request.getPingName() + " PONG").setPongId(request.getPingId()).build();
            message.setBody((Object)response);
        });
        this.fromF("grpc://localhost:{{camel.grpc.test.forward.completed.server.port}}/%s?consumerStrategy=PROPAGATION&forwardOnCompleted=true", new Object[]{PING_PONG_SERVICE}).to("mock:forwardOnCompleted");
        ((FilterDefinition)this.fromF("grpc://localhost:{{camel.grpc.test.forward.error.server.port}}/%s?consumerStrategy=PROPAGATION&forwardOnError=true", new Object[]{PING_PONG_SERVICE}).filter().body(Throwable.class)).to("mock:forwardOnError");
        this.from("direct:grpcStream").toF("grpc://localhost:{{camel.grpc.test.server.port}}/%s?producerStrategy=STREAMING&streamRepliesTo=direct:grpcStreamReplies&method=pingAsyncAsync", new Object[]{PING_PONG_SERVICE});
        this.fromF("grpc://localhost:{{camel.grpc.test.route.controlled.server.port}}/%s?synchronous=true&consumerStrategy=PROPAGATION&routeControlledStreamObserver=true", new Object[]{PING_PONG_SERVICE}).process(exchange -> {
            Message message = exchange.getMessage();
            PingRequest pingRequest = (PingRequest)message.getBody(PingRequest.class);
            StreamObserver responseObserver = (StreamObserver)exchange.getProperty("grpcResponseObserver");
            PongResponse pongResponse = PongResponse.newBuilder().setPongName(pingRequest.getPingName() + " PONG").setPongId(pingRequest.getPingId()).build();
            message.setBody((Object)pongResponse, PongResponse.class);
            exchange.setMessage(message);
            responseObserver.onNext((Object)pongResponse);
            responseObserver.onCompleted();
        });
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.fromF("grpc://localhost:{{camel.grpc.test.tls.server.port}}/%s?consumerStrategy=PROPAGATION&negotiationType=TLS&keyCertChainResource=certs/server.pem&keyResource=certs/server.key&trustCertCollectionResource=certs/ca.pem", new Object[]{PING_PONG_SERVICE}).process("messageOriginProcessor")).choice().when((Predicate)this.simple("${header.origin} == 'producer'")).bean((Object)new GrpcMessageBuilder(), "buildAsyncPongResponse")).endChoice().otherwise().to("mock:tls")).bean((Object)new GrpcMessageBuilder(), "buildAsyncPongResponse")).endChoice();
        this.from("direct:sendTls").toF("grpc://localhost:{{camel.grpc.test.tls.server.port}}/%s?method=pingSyncSync&synchronous=true&negotiationType=TLS&keyCertChainResource=certs/client.pem&keyResource=certs/client.key&trustCertCollectionResource=certs/ca.pem", new Object[]{PING_PONG_SERVICE});
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.fromF("grpc://localhost:{{camel.grpc.test.jwt.server.port}}/%s?consumerStrategy=PROPAGATION&authenticationType=JWT&jwtSecret=%s", new Object[]{PING_PONG_SERVICE, GRPC_JWT_SECRET}).process("messageOriginProcessor")).choice().when((Predicate)this.simple("${header.origin} == 'producer'")).bean((Object)new GrpcMessageBuilder(), "buildAsyncPongResponse")).endChoice().otherwise().to("mock:jwt")).bean((Object)new GrpcMessageBuilder(), "buildAsyncPongResponse")).endChoice();
        this.from("direct:sendJwt").toF("grpc://localhost:{{camel.grpc.test.jwt.server.port}}/%s?method=pingSyncSync&synchronous=true&authenticationType=JWT&jwtSecret=%s", new Object[]{PING_PONG_SERVICE, GRPC_JWT_SECRET});
        this.from("direct:grpcStreamReplies").to("mock:grpcStreamReplies");
    }

    @RegisterForReflection(fields=false)
    static final class GrpcMessageBuilder {
        GrpcMessageBuilder() {
        }

        public PongResponse buildAsyncPongResponse(PingRequest pingRequests) {
            return PongResponse.newBuilder().setPongName(pingRequests.getPingName() + " PONG").setPongId(pingRequests.getPingId()).build();
        }
    }
}

