/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.grpc.it.model.PingRequest;
import org.apache.camel.quarkus.component.grpc.it.model.PongResponse;

@Path(value="/grpc")
@ApplicationScoped
public class GrpcResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/producer")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String producer(String pingName, @QueryParam(value="pingId") int pingId) throws Exception {
        PingRequest pingRequest = PingRequest.newBuilder().setPingName(pingName).setPingId(pingId).build();
        PongResponse response = (PongResponse)this.producerTemplate.requestBody("grpc://localhost:{{grpc.test.server.port}}/org.apache.camel.quarkus.component.grpc.it.model.PingPong?method=pingSyncSync&synchronous=true", (Object)pingRequest, PongResponse.class);
        return response.getPongName();
    }

    @Path(value="/forwardOnCompleted")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> forwardOnCompleted() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:forwardOnCompleted", MockEndpoint.class);
        List exchanges = mockEndpoint.getExchanges();
        if (!exchanges.isEmpty()) {
            Exchange exchange = (Exchange)exchanges.get(0);
            return exchange.getMessage().getHeaders();
        }
        return Collections.emptyMap();
    }

    @Path(value="/forwardOnError")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> forwardOnError() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:forwardOnError", MockEndpoint.class);
        List exchanges = mockEndpoint.getExchanges();
        if (!exchanges.isEmpty()) {
            Exchange exchange = (Exchange)exchanges.get(0);
            Throwable throwable = (Throwable)exchange.getMessage().getBody(Throwable.class);
            Map results = exchange.getMessage().getHeaders();
            results.put("error", throwable.getClass().getName());
            return results;
        }
        return Collections.emptyMap();
    }

    @Path(value="/grpcStreamReplies")
    @GET
    public void grpcStreamReplies() throws InterruptedException {
        int messageCount = 10;
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:grpcStreamReplies", MockEndpoint.class);
        endpoint.expectedMessageCount(messageCount);
        for (int i = 1; i <= messageCount; ++i) {
            PingRequest request = PingRequest.newBuilder().setPingName(String.valueOf(i)).build();
            this.producerTemplate.sendBody("direct:grpcStream", (Object)request);
        }
        endpoint.assertIsSatisfied();
    }

    @Path(value="/tls")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> tlsConsumer() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:tls", MockEndpoint.class);
        List exchanges = mockEndpoint.getExchanges();
        if (!exchanges.isEmpty()) {
            Exchange exchange = (Exchange)exchanges.get(0);
            return exchange.getMessage().getHeaders();
        }
        return Collections.emptyMap();
    }

    @Path(value="/tls")
    @POST
    @Produces(value={"text/plain"})
    public String tlsProducer(String message) {
        PingRequest pingRequest = PingRequest.newBuilder().setPingName(message).setPingId(12345).build();
        PongResponse response = (PongResponse)this.producerTemplate.requestBodyAndHeader("direct:sendTls", (Object)pingRequest, "origin", (Object)"producer", PongResponse.class);
        return response.getPongName();
    }

    @Path(value="/jwt")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> jwtConsumer() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:jwt", MockEndpoint.class);
        List exchanges = mockEndpoint.getExchanges();
        if (!exchanges.isEmpty()) {
            Exchange exchange = (Exchange)exchanges.get(0);
            return exchange.getMessage().getHeaders();
        }
        return Collections.emptyMap();
    }

    @Path(value="/jwt")
    @POST
    @Produces(value={"text/plain"})
    public String jwtProducer(String message) {
        PingRequest pingRequest = PingRequest.newBuilder().setPingName(message).setPingId(12345).build();
        PongResponse response = (PongResponse)this.producerTemplate.requestBodyAndHeader("direct:sendJwt", (Object)pingRequest, "origin", (Object)"producer", PongResponse.class);
        return response.getPongName();
    }
}

