/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.quarkus.component.grpc.it.PingPongImpl;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServerTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcServerTestResource.class);
    private Server grpcServer;

    public Map<String, String> start() {
        try {
            int port = AvailablePortFinder.getNextAvailable();
            this.grpcServer = ServerBuilder.forPort((int)port).addService((BindableService)new PingPongImpl()).build().start();
            return CollectionHelper.mapOf((Object)"camel.grpc.test.server.port", (Object)String.valueOf(port), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start gRPC server", e);
        }
    }

    public void stop() {
        try {
            if (this.grpcServer != null) {
                this.grpcServer.shutdown();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not stop gRPC server", (Throwable)e);
        }
    }
}

