/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grok.it;

import io.krakens.grok.api.exception.GrokException;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class GrokTest {
    private static final String LOGS = "64.242.88.10 - - [07/Mar/2004:16:05:49 -0800] \"GET /twiki/bin/edit/Main/Double_bounce_sender?topicparent=Main.ConfigurationVariables HTTP/1.1\" 401 12846\n64.242.88.11 - - [07/Mar/2004:16:06:51 -0800] \"GET /twiki/bin/rdiff/TWiki/NewUserTemplate?rev1=1.3&rev2=1.2 HTTP/1.1\" 200 4523\n64.242.88.12 - - [07/Mar/2004:16:10:02 -0800] \"GET /mailman/listinfo/hsdivision HTTP/1.1\" 200 6291\n64.242.88.13 - - [07/Mar/2004:16:11:58 -0800] \"GET /twiki/bin/view/TWiki/WikiSyntax HTTP/1.1\" 200 7352\n64.242.88.14 - - [07/Mar/2004:16:20:55 -0800] \"GET /twiki/bin/view/Main/DCCAndPostFix HTTP/1.1\" 200 5253\n";

    GrokTest() {
    }

    @Test
    public void grokLogShouldCaptureFifthIp() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(LOGS).get("/grok/log", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"ip: 64.242.88.14"), new Matcher[0]);
    }

    @Test
    public void grokFooBarShouldCaptureCenterFoosAndBars() {
        String fooBar = "bar foobar bar -- barbarfoobarfoobar -- barbar";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("bar foobar bar -- barbarfoobarfoobar -- barbar").get("/grok/fooBar", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"-- barbarfoobarfoobar --"), new Matcher[0]);
    }

    @Test
    public void grokSpaceDelimitedIpsShouldCaptureFirstAndFourthIps() {
        String ips = "178.21.82.201 178.21.82.202 178.21.82.203 178.21.82.204";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("178.21.82.201 178.21.82.202 178.21.82.203 178.21.82.204").get("/grok/ip", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"178.21.82.201 -> 178.21.82.204"), new Matcher[0]);
    }

    @Test
    public void grokMixDelimitedIpsShouldCaptureFirstAndFourthIps() {
        String ips = "178.21.82.101 178.21.82.102\n178.21.82.103\r\n178.21.82.104";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("178.21.82.101 178.21.82.102\n178.21.82.103\r\n178.21.82.104").get("/grok/ip", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"178.21.82.101 -> 178.21.82.104"), new Matcher[0]);
    }

    @Test
    public void grokQsShouldCaptureQuotedString() {
        String qs = "this is some \"quoted string\".";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("this is some \"quoted string\".").get("/grok/qs", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"quoted string"), new Matcher[0]);
    }

    @Test
    public void grokUuidShouldCaptureUuidAtEnd() {
        String uuid = "some 123e4567-e89b-12d3-a456-426614174000";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("some 123e4567-e89b-12d3-a456-426614174000").get("/grok/uuid", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"123e4567-e89b-12d3-a456-426614174000"), new Matcher[0]);
    }

    @Test
    public void grokMacShouldCaptureMacAddressAtEnd() {
        String mac = "some:invalid:prefix:of:eth0:02:00:4c:4f:4f:50";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("some:invalid:prefix:of:eth0:02:00:4c:4f:4f:50").get("/grok/mac", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"02:00:4c:4f:4f:50"), new Matcher[0]);
    }

    @Test
    public void grokPathShouldCaptureMntRelativePath() {
        String path = "The file with path /home/user/../../mnt has been deleted";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("The file with path /home/user/../../mnt has been deleted").get("/grok/path", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"/home/user/../../mnt"), new Matcher[0]);
    }

    @Test
    public void grokUriShouldCaptureCamelSiteUri() {
        String uri = "the site is at https://camel.apache.org/";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("the site is at https://camel.apache.org/").get("/grok/uri", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"https://camel.apache.org/"), new Matcher[0]);
    }

    @Test
    public void grokNumberShouldCapture123() {
        String number = "number is 123.";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("number is 123.").get("/grok/num", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"123"), new Matcher[0]);
    }

    @Test
    public void grokTimestampShouldCaptureMay26th() {
        String timestamp = "This test was created at 2019-05-26T10:54:15Z test convert";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("This test was created at 2019-05-26T10:54:15Z test convert").get("/grok/timestamp", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2019-05-26T10:54:15Z"), new Matcher[0]);
    }

    @Test
    public void grokFlattenShouldReturnGrokExceptionClassName() {
        String expected = GrokException.class.getName();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("1 2").get("/grok/flatten", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void grokNamedOnlyShouldNotCaptureUnamedExpressions() {
        String body = "https://github.com/apache/camel";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("https://github.com/apache/camel").get("/grok/namedOnly", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"false-false+false"), new Matcher[0]);
    }

    @Test
    public void grokSingleMathPerLineShouldCapture1AndThen3() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("1 2 \n 3").get("/grok/singleMatchPerLine", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1-3"), new Matcher[0]);
    }
}

