/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.graphql.it;

import graphql.GraphQL;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.graphql.GraphQLHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.graphql.it.model.Book;
import org.apache.camel.util.json.JsonObject;

@Path(value="/graphql")
public class GraphQLResource {
    private static final List<Book> BOOKS = Arrays.asList(new Book("book-1", "Harry Potter and the Philosophers Stone", "author-1"), new Book("book-2", "Moby Dick", "author-2"), new Book("book-3", "Interview with the vampire", "author-3"));
    @Inject
    ProducerTemplate producerTemplate;

    public void setupRouter(@Observes Router router) {
        TypeDefinitionRegistry typeDefinitionRegistry;
        SchemaParser schemaParser = new SchemaParser();
        try (InputStreamReader r = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("graphql/schema.graphql"), StandardCharsets.UTF_8);){
            typeDefinitionRegistry = schemaParser.parse((Reader)r);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DataFetcher dataFetcher = environment -> {
            CompletableFuture<Book> completableFuture = new CompletableFuture<Book>();
            Book book = this.getBookById(environment);
            completableFuture.complete(book);
            return completableFuture;
        };
        RuntimeWiring runtimeWiring = RuntimeWiring.newRuntimeWiring().type("Query", builder -> builder.dataFetcher("bookById", dataFetcher)).build();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        GraphQLSchema graphQLSchema = schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        router.route("/graphql/server").handler((Handler)GraphQLHandler.create((GraphQL)graphQL));
    }

    @Path(value="/query")
    @GET
    @Produces(value={"application/json"})
    public Response multipleQueries(@QueryParam(value="testPort") int port, @QueryParam(value="bookId") String bookId) {
        JsonObject variables = new JsonObject();
        variables.put((Object)"id", (Object)bookId);
        this.producerTemplate.getCamelContext().getRegistry().bind("bookByIdQueryVariables", (Object)variables);
        String result = (String)this.producerTemplate.requestBody("graphql://http://localhost:" + port + "/graphql/server?queryFile=graphql/bookQuery.graphql&operationName=BookById&variables=#bookByIdQueryVariables", null, String.class);
        return Response.ok().entity((Object)result).build();
    }

    private Book getBookById(DataFetchingEnvironment environment) {
        String bookId = (String)environment.getArgument("id");
        return BOOKS.stream().filter(book -> book.getId().equals(bookId)).findFirst().orElse(null);
    }
}

