/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.it;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.Request;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.SpreadsheetProperties;
import com.google.api.services.sheets.v4.model.UpdateSpreadsheetPropertiesRequest;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;

@Path(value="/google-sheets")
public class GoogleSheetsResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/create")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createSheet(String title) throws Exception {
        SpreadsheetProperties sheetProperties = new SpreadsheetProperties();
        sheetProperties.setTitle(title);
        Spreadsheet sheet = new Spreadsheet();
        sheet.setProperties(sheetProperties);
        Spreadsheet response = (Spreadsheet)this.producerTemplate.requestBody("google-sheets://spreadsheets/create?inBody=content", (Object)sheet, Spreadsheet.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getSpreadsheetId()).build();
    }

    @Path(value="/read")
    @GET
    @Produces(value={"text/plain"})
    public Response readSheet(@QueryParam(value="spreadsheetId") String spreadsheetId) {
        try {
            Spreadsheet response = (Spreadsheet)this.producerTemplate.requestBody("google-sheets://spreadsheets/get?inBody=spreadsheetId", (Object)spreadsheetId, Spreadsheet.class);
            if (response != null) {
                return Response.ok((Object)response.getProperties().getTitle()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (CamelExecutionException e) {
            Exception exchangeException = e.getExchange().getException();
            if (exchangeException != null && exchangeException.getCause() instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException originalException = (GoogleJsonResponseException)exchangeException.getCause();
                return Response.status((int)originalException.getStatusCode()).build();
            }
            throw e;
        }
    }

    @Path(value="/update")
    @PATCH
    @Consumes(value={"text/plain"})
    public Response updateSheet(@QueryParam(value="spreadsheetId") String spreadsheetId, String title) {
        BatchUpdateSpreadsheetRequest request = new BatchUpdateSpreadsheetRequest().setIncludeSpreadsheetInResponse(Boolean.valueOf(true)).setRequests(Collections.singletonList(new Request().setUpdateSpreadsheetProperties(new UpdateSpreadsheetPropertiesRequest().setProperties(new SpreadsheetProperties().setTitle(title)).setFields("title"))));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelGoogleSheets.spreadsheetId", spreadsheetId);
        headers.put("CamelGoogleSheets.batchUpdateSpreadsheetRequest", (String)request);
        this.producerTemplate.requestBodyAndHeaders("google-sheets://spreadsheets/batchUpdate", null, headers);
        return Response.ok().build();
    }
}

