/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.it;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.calendar.model.Calendar;
import com.google.api.services.calendar.model.Event;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;

@Path(value="/google-calendar")
public class GoogleCalendarResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/create")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createCalendar(String summary) throws Exception {
        Calendar calendar = new Calendar();
        calendar.setSummary(summary);
        calendar.setTimeZone("Europe/London");
        Calendar response = (Calendar)this.producerTemplate.requestBody("google-calendar://calendars/insert?inBody=content", (Object)calendar, Calendar.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getId()).build();
    }

    @Path(value="/create/event")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createCalendarEvent(@QueryParam(value="calendarId") String calendarId, String eventText) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelGoogleCalendar.calendarId", calendarId);
        headers.put("CamelGoogleCalendar.text", eventText);
        Event response = (Event)this.producerTemplate.requestBodyAndHeaders("google-calendar://events/quickAdd", null, headers, Event.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getId()).build();
    }

    @Path(value="/read")
    @GET
    @Produces(value={"text/plain"})
    public Response readCalendar(@QueryParam(value="calendarId") String calendarId) {
        try {
            Calendar response = (Calendar)this.producerTemplate.requestBody("google-calendar://calendars/get?inBody=calendarId", (Object)calendarId, Calendar.class);
            if (response != null) {
                return Response.ok((Object)response.getSummary()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (CamelExecutionException e) {
            Exception exchangeException = e.getExchange().getException();
            if (exchangeException != null && exchangeException.getCause() instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException originalException = (GoogleJsonResponseException)exchangeException.getCause();
                return Response.status((int)originalException.getStatusCode()).build();
            }
            throw e;
        }
    }

    @Path(value="/read/event")
    @GET
    @Produces(value={"text/plain"})
    public Response readCalendarEvent(@QueryParam(value="calendarId") String calendarId, @QueryParam(value="eventId") String eventId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelGoogleCalendar.calendarId", calendarId);
        headers.put("CamelGoogleCalendar.eventId", eventId);
        try {
            Event response = (Event)this.producerTemplate.requestBodyAndHeaders("google-calendar://events/get", null, headers, Event.class);
            if (response != null) {
                return Response.ok((Object)response.getSummary()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (CamelExecutionException e) {
            Exception exchangeException = e.getExchange().getException();
            if (exchangeException != null && exchangeException.getCause() instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException originalException = (GoogleJsonResponseException)exchangeException.getCause();
                return Response.status((int)originalException.getStatusCode()).build();
            }
            throw e;
        }
    }

    @Path(value="/update/event")
    @PATCH
    public Response updateCalendarEvent(@QueryParam(value="calendarId") String calendarId, @QueryParam(value="eventId") String eventId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelGoogleCalendar.calendarId", calendarId);
        headers.put("CamelGoogleCalendar.eventId", eventId);
        try {
            Event response = (Event)this.producerTemplate.requestBodyAndHeaders("google-calendar://events/get", null, headers, Event.class);
            if (response == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            response.setSummary(response.getSummary() + " Updated");
            headers = new HashMap();
            headers.put("CamelGoogleCalendar.calendarId", calendarId);
            headers.put("CamelGoogleCalendar.eventId", eventId);
            headers.put("CamelGoogleCalendar.content", (String)response);
            this.producerTemplate.requestBodyAndHeaders("google-calendar://events/update", null, headers);
            return Response.ok().build();
        }
        catch (CamelExecutionException e) {
            Exception exchangeException = e.getExchange().getException();
            if (exchangeException != null && exchangeException.getCause() instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException originalException = (GoogleJsonResponseException)exchangeException.getCause();
                return Response.status((int)originalException.getStatusCode()).build();
            }
            throw e;
        }
    }

    @Path(value="/delete")
    @DELETE
    public Response deleteCalendar(@QueryParam(value="calendarId") String calendarId) {
        this.producerTemplate.requestBody("google-calendar://calendars/delete?inBody=calendarId", (Object)calendarId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

