/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariables;

@EnabledIfEnvironmentVariables(value={@EnabledIfEnvironmentVariable(named="GOOGLE_API_APPLICATION_NAME", matches=".+"), @EnabledIfEnvironmentVariable(named="GOOGLE_API_CLIENT_ID", matches=".+"), @EnabledIfEnvironmentVariable(named="GOOGLE_API_CLIENT_SECRET", matches=".+"), @EnabledIfEnvironmentVariable(named="GOOGLE_API_REFRESH_TOKEN", matches=".+")})
@QuarkusTest
class GoogleComponentsTest {
    GoogleComponentsTest() {
    }

    @Test
    public void testGoogleCalendarComponent() {
        String summary = "Camel Quarkus Google Calendar";
        String eventText = summary = summary + " Event";
        String calendarId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(summary).post("/google-calendar/create", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("calendarId", new Object[]{calendarId}).get("/google-calendar/read", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)summary), new Matcher[0]);
        String eventId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("calendarId", new Object[]{calendarId}).body(eventText).post("/google-calendar/create/event", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("calendarId", new Object[]{calendarId}).queryParam("eventId", new Object[]{eventId}).get("/google-calendar/read/event", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)eventText), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("calendarId", new Object[]{calendarId}).queryParam("eventId", new Object[]{eventId}).patch("/google-calendar/update/event", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("calendarId", new Object[]{calendarId}).queryParam("eventId", new Object[]{eventId}).get("/google-calendar/read/event", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)(eventText + " Updated")), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("calendarId", new Object[]{calendarId}).delete("/google-calendar/delete", new Object[0])).then()).statusCode(204);
        Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> {
            int code = ((ValidatableResponse)((Response)RestAssured.given().queryParam("calendarId", new Object[]{calendarId}).post("/google-calendar/read", new Object[0])).then()).extract().statusCode();
            return code != 404;
        });
    }

    @Test
    public void testGoogleDriveComponent() {
        String title = UUID.randomUUID().toString();
        String fileId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(title).post("/google-drive/create", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fileId", new Object[]{fileId}).get("/google-drive/read", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)title), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("fileId", new Object[]{fileId}).delete("/google-drive/delete", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("fileId", new Object[]{fileId}).get("/google-drive/read", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testGoogleMailComponent() {
        String message = "Hello Camel Quarkus Google Mail";
        String messageId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/google-mail/create", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("messageId", new Object[]{messageId}).get("/google-mail/read", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)message), new Matcher[0]);
        Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> {
            int code = ((ValidatableResponse)((Response)RestAssured.given().queryParam("messageId", new Object[]{messageId}).delete("/google-mail/delete", new Object[0])).then()).extract().statusCode();
            return code == 204;
        });
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("messageId", new Object[]{messageId}).get("/google-mail/read", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testGoogleSheetsComponent() {
        String title = "Camel Quarkus Google Sheet";
        String sheetId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(title).post("/google-sheets/create", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("spreadsheetId", new Object[]{sheetId}).get("/google-sheets/read", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)title), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("spreadsheetId", new Object[]{sheetId}).body(title + " Updated").patch("/google-sheets/update", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("spreadsheetId", new Object[]{sheetId}).get("/google-sheets/read", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)(title + " Updated")), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("fileId", new Object[]{sheetId}).delete("/google-drive/delete", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("fileId", new Object[]{sheetId}).get("/google-drive/read", new Object[0])).then()).statusCode(404);
    }
}

