/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.it;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.gmail.model.Message;
import com.google.api.services.gmail.model.Profile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;

@Path(value="/google-mail")
public class GoogleMailResource {
    private static final String EMAIL_SUBJECT = "Camel Quarkus Google Mail Test";
    private static final String USER_ID = "me";
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/create")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createMail(String message) throws Exception {
        Message email = this.createMessage(message);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelGoogleMail.userId", USER_ID);
        headers.put("CamelGoogleMail.content", (String)email);
        Message response = (Message)this.producerTemplate.requestBodyAndHeaders("google-mail://messages/send", null, headers, Message.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getId()).build();
    }

    @Path(value="/read")
    @GET
    @Produces(value={"text/plain"})
    public Response readMail(@QueryParam(value="messageId") String messageId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelGoogleMail.userId", USER_ID);
        headers.put("CamelGoogleMail.id", messageId);
        try {
            Message response = (Message)this.producerTemplate.requestBodyAndHeaders("google-mail://messages/get", null, headers, Message.class);
            if (response != null && response.getPayload() != null) {
                String body = new String(response.getPayload().getBody().decodeData(), StandardCharsets.UTF_8);
                return Response.ok((Object)body).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (CamelExecutionException e) {
            Exception exchangeException = e.getExchange().getException();
            if (exchangeException != null && exchangeException.getCause() instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException originalException = (GoogleJsonResponseException)exchangeException.getCause();
                return Response.status((int)originalException.getStatusCode()).build();
            }
            throw e;
        }
    }

    @Path(value="/delete")
    @DELETE
    public Response deleteMail(@QueryParam(value="messageId") String messageId, String message) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelGoogleMail.userId", USER_ID);
        headers.put("CamelGoogleMail.id", messageId);
        this.producerTemplate.requestBodyAndHeaders("google-mail://messages/delete", (Object)message, headers);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private Message createMessage(String body) throws MessagingException, IOException {
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        Profile profile = (Profile)this.producerTemplate.requestBody("google-mail://users/getProfile?inBody=userId", (Object)USER_ID, Profile.class);
        MimeMessage mm = new MimeMessage(session);
        mm.addRecipients(Message.RecipientType.TO, profile.getEmailAddress());
        mm.setSubject(EMAIL_SUBJECT);
        mm.setContent((Object)body, "text/plain");
        Message message = new Message();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            mm.writeTo((OutputStream)baos);
            message.setRaw(Base64.getUrlEncoder().encodeToString(baos.toByteArray()));
        }
        return message;
    }
}

