/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.it;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.services.drive.model.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;

@Path(value="/google-drive")
public class GoogleDriveResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/create")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createFile(String title) throws Exception {
        File fileMetadata = new File();
        fileMetadata.setTitle(title);
        ByteArrayContent mediaContent = new ByteArrayContent("text/plain", "Hello Camel Quarkus Google Drive".getBytes(StandardCharsets.UTF_8));
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelGoogleDrive.content", fileMetadata);
        headers.put("CamelGoogleDrive.mediaContent", mediaContent);
        File response = (File)this.producerTemplate.requestBodyAndHeaders("google-drive://drive-files/insert", null, headers, File.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getId()).build();
    }

    @Path(value="/read")
    @GET
    @Produces(value={"text/plain"})
    public Response readFile(@QueryParam(value="fileId") String fileId) {
        try {
            File response = (File)this.producerTemplate.requestBody("google-drive://drive-files/get?inBody=fileId", (Object)fileId, File.class);
            if (response != null) {
                return Response.ok((Object)response.getTitle()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (CamelExecutionException e) {
            Exception exchangeException = e.getExchange().getException();
            if (exchangeException != null && exchangeException.getCause() instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException originalException = (GoogleJsonResponseException)exchangeException.getCause();
                return Response.status((int)originalException.getStatusCode()).build();
            }
            throw e;
        }
    }

    @Path(value="/delete")
    @DELETE
    public Response deleteFile(@QueryParam(value="fileId") String fileId) {
        this.producerTemplate.requestBody("google-drive://drive-files/delete?inBody=fileId", (Object)fileId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

