/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.storage.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.quarkus.component.google.storage.it.GoogleStorageHelper;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.eclipse.microprofile.config.ConfigProvider;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;

public class GoogleStorageTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final int PORT = AvailablePortFinder.getNextAvailable();
    public static final String CONTAINER_NAME = (String)ConfigProvider.getConfig().getValue("google-storage.container.image", String.class);
    private GenericContainer<?> container;

    public Map<String, String> start() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (GoogleStorageHelper.usingMockBackend()) {
            this.container = new FixedHostPortGenericContainer(CONTAINER_NAME).withFixedExposedPort(PORT, PORT).withCreateContainerCmdModifier(it -> it.withEntrypoint(new String[]{"/bin/fake-gcs-server", "-scheme", "http", "-port", String.valueOf(PORT)}));
            this.container.start();
            properties.put("org.apache.camel.quarkus.component.googlr.storage.it.GoogleStorageClientProducer_port", String.valueOf(PORT));
        }
        return properties;
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

