/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.storage.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.component.google.storage.GoogleCloudStorageOperations;
import org.apache.camel.quarkus.component.google.storage.it.GoogleStorageHelper;
import org.apache.camel.quarkus.component.google.storage.it.GoogleStorageTestResource;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.apache.camel.util.CollectionHelper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@QuarkusTestResource(value=GoogleStorageTestResource.class)
class GoogleStorageTest {
    private static final Logger log = LoggerFactory.getLogger(GoogleStorageTest.class);
    private static final String FILE_NAME_007 = "file007";
    private static final String FILE_NAME_006 = "file006";

    GoogleStorageTest() {
    }

    @AfterEach
    public void afterEach() {
        if (!GoogleStorageHelper.usingMockBackend()) {
            ((ValidatableResponse)((Response)RestAssured.given().get("/google-storage/deleteBuckets", new Object[0])).then()).statusCode(200);
        }
    }

    @Test
    public void testConsumer() throws InterruptedException {
        log.info("testConsumer started");
        try {
            this.putObject("Sheldon", "camel_quarkus_test_bucket3", FILE_NAME_007);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().post("/google-storage/getFromDirect", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Sheldon"), new Matcher[0]);
            GoogleStorageTest.executeOperation("camel_quarkus_test_dest_bucket", GoogleCloudStorageOperations.getObject, Collections.singletonMap("CamelGoogleCloudStorageObjectName", FILE_NAME_007), Matchers.is((Object)"Sheldon"));
        }
        finally {
            if (!GoogleStorageHelper.usingMockBackend()) {
                ((ValidatableResponse)((Response)RestAssured.given().get("/google-storage/stopRoute", new Object[0])).then()).statusCode(200);
            }
        }
    }

    @Test
    public void testProducer() {
        String buckets;
        List<String> bucketsToDelete;
        log.info("testProducer started");
        if (!MockBackendUtils.startMockBackend() && !(bucketsToDelete = Arrays.stream((buckets = GoogleStorageTest.executeOperation(GoogleCloudStorageOperations.listBuckets, Collections.emptyMap(), null)).split(",")).filter(b -> b.equals("camel_quarkus_test_bucket1") || b.equals("camel_quarkus_test_bucket2")).collect(Collectors.toList())).isEmpty()) {
            bucketsToDelete.forEach(b -> GoogleStorageTest.executeOperation(b, GoogleCloudStorageOperations.deleteBucket, Collections.emptyMap(), Matchers.is((Object)Boolean.toString(true))));
        }
        this.putObject("Sheldon", "camel_quarkus_test_bucket1", FILE_NAME_007);
        this.putObject("Irma", "camel_quarkus_test_bucket2", FILE_NAME_006);
        GoogleStorageTest.executeOperation(GoogleCloudStorageOperations.copyObject, CollectionHelper.mapOf((Object)"CamelGoogleCloudStorageObjectName", (Object)FILE_NAME_007, (Object[])new Object[]{"CamelGoogleCloudStorageDestinationBucketName", "camel_quarkus_test_bucket2", "CamelGoogleCloudStorageDestinationObjectName", "file007_copy"}), Matchers.is((Object)"Sheldon"));
        GoogleStorageTest.executeOperation("camel_quarkus_test_bucket2", GoogleCloudStorageOperations.getObject, Collections.singletonMap("CamelGoogleCloudStorageObjectName", "file007_copy"), Matchers.is((Object)"Sheldon"));
        GoogleStorageTest.executeOperation(GoogleCloudStorageOperations.listBuckets, Collections.emptyMap(), (Matcher)Matchers.both((Matcher)Matchers.containsString((String)"camel_quarkus_test_bucket1")).and(Matchers.containsString((String)"camel_quarkus_test_bucket2")));
        GoogleStorageTest.executeOperation("camel_quarkus_test_bucket2", GoogleCloudStorageOperations.deleteObject, CollectionHelper.mapOf((Object)"CamelGoogleCloudStorageObjectName", (Object)FILE_NAME_006, (Object[])new Object[0]), Matchers.is((Object)Boolean.toString(true)));
        GoogleStorageTest.executeOperation("camel_quarkus_test_bucket2", GoogleCloudStorageOperations.listObjects, Collections.emptyMap(), Matchers.containsString((String)"file007_copy"));
        if (!GoogleStorageHelper.usingMockBackend()) {
            GoogleStorageTest.executeOperation("camel_quarkus_test_bucket2", GoogleCloudStorageOperations.createDownloadLink, Collections.singletonMap("CamelGoogleCloudStorageObjectName", "file007_copy"), Matchers.startsWith((String)"http"));
        }
    }

    private void putObject(String content, String bucketName, String fileName) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(content).queryParam("bucketName", new Object[]{bucketName}).queryParam("objectName", new Object[]{fileName}).post("/google-storage/putObject", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)fileName), new Matcher[0]);
    }

    private static String executeOperation(GoogleCloudStorageOperations operation, Map<String, Object> parameters, Matcher matcher) {
        return GoogleStorageTest.executeOperation("camel_quarkus_test_bucket1", operation, parameters, matcher);
    }

    private static String executeOperation(String bucketName, GoogleCloudStorageOperations operation, Map<String, Object> parameters, Matcher matcher) {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(parameters).queryParam("bucketName", new Object[]{bucketName}).queryParam("operation", new Object[]{operation}).post("/google-storage/operation", new Object[0])).then()).statusCode(200);
        if (matcher != null) {
            response.body(matcher, new Matcher[0]);
        }
        return response.extract().asString();
    }
}

