/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.pubsub.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.google.GoogleCloudTestResource;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;

@QuarkusTest
@QuarkusTestResource(value=GoogleCloudTestResource.class)
class GooglePubsubTest {
    private static final Logger LOG = Logger.getLogger(GooglePubsubTest.class);

    GooglePubsubTest() {
    }

    @Test
    public void pubsubTopicProduceConsume() {
        String message = "Hello Camel Quarkus Google PubSub";
        ((ValidatableResponse)((Response)RestAssured.given().body(message).post("/google-pubsub", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/google-pubsub", (Object[])new Object[0]).then()).statusCode(200)).body("body", Matchers.is((Object)message), new Object[0])).body("CamelGooglePubsubMessageId".replaceFirst("\\.", "_"), Matchers.notNullValue(), new Object[0])).body("CamelGooglePubsubPublishTime".replaceFirst("\\.", "_"), Matchers.notNullValue(), new Object[0])).body("CamelGooglePubsubMsgAckId".replaceFirst("\\.", "_"), Matchers.notNullValue(), new Object[0]);
    }

    @Test
    public void jacksonSerializer() {
        String fruitName = "Apple";
        ((ValidatableResponse)((Response)RestAssured.given().body(fruitName).post("/google-pubsub/pojo", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/google-pubsub/pojo", (Object[])new Object[0]).then()).statusCode(200)).body("name", Matchers.is((Object)fruitName), new Object[0]);
    }

    @Test
    public void testGrouped() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("toEndpoint", new Object[]{"direct:grouped_id"}).body("body1").post("/google-pubsub/sendToEndpoint", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/receive/subscription/google-pubsub.grouped-subscription-name", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("toEndpoint", new Object[]{"direct:grouped_id"}).body("body2").post("/google-pubsub/sendToEndpoint", new Object[0])).then()).statusCode(201);
        HashSet<String> results = new HashSet<String>();
        results.add(((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/receive/subscription/google-pubsub.grouped-subscription-name", new Object[0])).then()).statusCode(200)).extract().asString());
        results.add(((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/receive/subscription/google-pubsub.grouped-subscription-name", new Object[0])).then()).statusCode(200)).extract().asString());
        Assertions.assertTrue((boolean)results.contains("body1"));
        Assertions.assertTrue((boolean)results.contains("body2"));
    }

    @DisabledIfEnvironmentVariable(named="GOOGLE_APPLICATION_CREDENTIALS", matches=".+")
    @Test
    public void testOrdering() throws Exception {
        LOG.info((Object)"Start of the ordering test");
        String messages = "1,2,3,4,5,6";
        for (String message : messages.split(",")) {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("toEndpoint", new Object[]{"direct:ordering_in"}).body(message).post("/google-pubsub/sendToEndpoint", new Object[0])).then()).statusCode(201);
        }
        LOG.info((Object)"All messages were sent");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/receive/subscriptionOrdering/google-pubsub.ordering-subscription-name", new Object[0])).then()).statusCode(200)).extract().asString(), Matchers.is((Object)messages));
    }

    @Test
    public void testAck() throws Exception {
        LOG.info((Object)"Start of the acking test");
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)false).post("/google-pubsub/setFail", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("toEndpoint", new Object[]{"direct:ack_in"}).body("1").post("/google-pubsub/sendToEndpoint", new Object[0])).then()).statusCode(201);
        LOG.info((Object)"Message \"1\" was sent and should be Acked.");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/receive/mock/mock:ack_result", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]));
        LOG.info((Object)"Message \"1\" was received.");
        ((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/resetMock/mock:ack_result", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)true).post("/google-pubsub/setFail", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("toEndpoint", new Object[]{"direct:ack_in"}).body("2").post("/google-pubsub/sendToEndpoint", new Object[0])).then()).statusCode(201);
        LOG.info((Object)"Message \"2\" was sent and should be Nacked.");
        Thread.sleep(5000L);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/receive/mock/mock:ack_result", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)""), new Matcher[0]);
        LOG.info((Object)"Message \"2\" was not delivered.");
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)false).post("/google-pubsub/setFail", new Object[0])).then()).statusCode(201);
        LOG.info((Object)"Acking was enabled.");
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/google-pubsub/receive/mock/mock:ack_result", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]));
        LOG.info((Object)"Message \"2\" was delivered after acking was enabled.");
    }
}

