/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.pubsub.it;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.google.pubsub.it.Fruit;

@Path(value="/google-pubsub")
public class GooglePubsubResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @POST
    public Response sendStringToTopic(String message) {
        this.producerTemplate.sendBody("google-pubsub:{{project.id}}:{{topic.name}}", (Object)message);
        return Response.created((URI)URI.create("https://camel.apache.org")).build();
    }

    @GET
    public Response consumeStringFromTopic() {
        Object response = this.consumerTemplate.receiveBody("google-pubsub:{{project.id}}:{{subscription.name}}?synchronousPull=true", 5000L);
        return Response.ok((Object)response).build();
    }

    @Path(value="/pojo")
    @POST
    public Response sendPojoToTopic(String fruitName) {
        Fruit fruit = new Fruit(fruitName);
        this.producerTemplate.sendBody("google-pubsub:{{project.id}}:{{topic.name}}", (Object)fruit);
        return Response.created((URI)URI.create("https://camel.apache.org")).build();
    }

    @Path(value="/pojo")
    @GET
    @Produces(value={"application/json"})
    public Response consumePojoFromTopic() {
        Object response = this.consumerTemplate.receiveBody("google-pubsub:{{project.id}}:{{subscription.name}}?synchronousPull=true", 5000L);
        return Response.ok((Object)response).build();
    }
}

