/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.pubsub.it;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.CollectionHelper;
import org.testcontainers.containers.PubSubEmulatorContainer;
import org.testcontainers.utility.DockerImageName;

public class GooglePubsubTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final String PROJECT_ID = "test-project";
    private static final String TOPIC = "test-topic";
    private static final String SUBSCRIPTION = "test-topic-subscription";
    private static final String GOOGLE_PUBSUB_IMAGE = "gcr.io/google.com/cloudsdktool/cloud-sdk:emulators";
    private PubSubEmulatorContainer container;

    public Map<String, String> start() {
        try {
            DockerImageName imageName = DockerImageName.parse((String)GOOGLE_PUBSUB_IMAGE);
            this.container = new PubSubEmulatorContainer(imageName);
            this.container.start();
            this.createTopicSubscriptionPair(TOPIC, SUBSCRIPTION);
            return CollectionHelper.mapOf((Object)"project.id", (Object)PROJECT_ID, (Object[])new Object[]{"topic.name", TOPIC, "subscription.name", SUBSCRIPTION, "camel.component.google-pubsub.endpoint", this.container.getEmulatorEndpoint()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTopicSubscriptionPair(String topicName, String subscriptionName) throws InterruptedException {
        TopicName projectTopicName = TopicName.of((String)PROJECT_ID, (String)topicName);
        ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)PROJECT_ID, (String)subscriptionName);
        Topic topic = Topic.newBuilder().setName(projectTopicName.toString()).build();
        Subscription subscription = Subscription.newBuilder().setName(projectSubscriptionName.toString()).setTopic(topic.getName()).setAckDeadlineSeconds(10).build();
        this.createTopicSubscriptionPair(topic, subscription);
    }

    public void createTopicSubscriptionPair(Topic topic, Subscription subscription) throws InterruptedException {
        this.createTopic(topic);
        this.createSubscription(subscription);
    }

    public void createTopic(Topic topic) throws InterruptedException {
        TopicAdminClient topicAdminClient = this.createTopicAdminClient();
        topicAdminClient.createTopic(topic);
        topicAdminClient.shutdown();
        topicAdminClient.awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void createSubscription(Subscription subscription) throws InterruptedException {
        SubscriptionAdminClient subscriptionAdminClient = this.createSubscriptionAdminClient();
        subscriptionAdminClient.createSubscription(subscription);
        subscriptionAdminClient.shutdown();
        subscriptionAdminClient.awaitTermination(5L, TimeUnit.SECONDS);
    }

    private FixedTransportChannelProvider createChannelProvider() {
        Integer port = this.container.getFirstMappedPort();
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)String.format("%s:%s", "localhost", port)).usePlaintext().build();
        return FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
    }

    private TopicAdminClient createTopicAdminClient() {
        FixedTransportChannelProvider channelProvider = this.createChannelProvider();
        NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
        try {
            return TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)credentialsProvider)).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SubscriptionAdminClient createSubscriptionAdminClient() {
        FixedTransportChannelProvider channelProvider = this.createChannelProvider();
        NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
        try {
            return SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)credentialsProvider)).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

