/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.pubsub.it;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.google.GoogleCloudContext;
import org.apache.camel.quarkus.test.support.google.GoogleTestEnvCustomizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PubSubEmulatorContainer;
import org.testcontainers.utility.DockerImageName;

public class GooglePubSubCustomizer
implements GoogleTestEnvCustomizer {
    private static final String TEST_PROJECT_ID = "test-project";
    private PubSubEmulatorContainer container;

    public GenericContainer createContainer() {
        DockerImageName imageName = DockerImageName.parse((String)"gcr.io/google.com/cloudsdktool/cloud-sdk:390.0.0-emulators");
        this.container = new PubSubEmulatorContainer(imageName);
        return this.container;
    }

    public void customize(GoogleCloudContext envContext) {
        try {
            SubscriptionAdminClient subscriptionClient = this.createSubscriptionAdminClient(envContext);
            TopicAdminClient topicClient = this.createTopicAdminClient(envContext);
            String projectId = envContext.getProperties().getOrDefault("google.project.id", TEST_PROJECT_ID);
            envContext.property("project.id", projectId);
            if (this.container != null) {
                envContext.property("camel.component.google-pubsub.authenticate", "false");
                envContext.property("camel.component.google-pubsub.endpoint", this.container.getEmulatorEndpoint());
            }
            String topicName = "camel-quarkus-topic-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.topic-name", topicName);
            String subscriptionName = "camel-quarkus-subscription-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.subscription-name", subscriptionName);
            String groupedTopicName = "camel-quarkus-grouped-topic-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.grouped-topic-name", groupedTopicName);
            String groupedSubscriptionName = "camel-quarkus-grouped-subscription-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.grouped-subscription-name", groupedSubscriptionName);
            String orderingTopicName = "camel-quarkus-ordering-topic-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.ordering-topic-name", orderingTopicName);
            String orderingSubscriptionName = "camel-quarkus-ordering-subscription-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.ordering-subscription-name", orderingSubscriptionName);
            String ackTopicName = "camel-quarkus-ack-topic-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.ack-topic-name", ackTopicName);
            String ackSubscriptionName = "camel-quarkus-ack-subscription-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
            envContext.property("google-pubsub.ack-subscription-name", ackSubscriptionName);
            Topic topic = this.createTopic(topicClient, topicName, projectId);
            Subscription subscription = this.createSubscription(subscriptionClient, topic, subscriptionName, projectId);
            Topic topicGrouped = this.createTopic(topicClient, groupedTopicName, projectId);
            Subscription subscriptionGrouped = this.createSubscription(subscriptionClient, topicGrouped, groupedSubscriptionName, projectId);
            Topic topicOrdering = this.createTopic(topicClient, orderingTopicName, projectId);
            Subscription subscriptionOrdering = this.createSubscription(subscriptionClient, topicOrdering, orderingSubscriptionName, projectId, true);
            Topic topicAck = this.createTopic(topicClient, ackTopicName, projectId);
            Subscription subscriptionAck = this.createSubscription(subscriptionClient, topicAck, ackSubscriptionName, projectId);
            envContext.closeable(() -> {
                subscriptionClient.deleteSubscription(subscriptionGrouped.getName());
                topicClient.deleteTopic(topicGrouped.getName());
                subscriptionClient.deleteSubscription(subscriptionAck.getName());
                topicClient.deleteTopic(topicAck.getName());
                subscriptionClient.deleteSubscription(subscriptionOrdering.getName());
                topicClient.deleteTopic(topicOrdering.getName());
                subscriptionClient.deleteSubscription(subscription.getName());
                topicClient.deleteTopic(topic.getName());
                topicClient.shutdown();
                subscriptionClient.shutdown();
                topicClient.awaitTermination(5L, TimeUnit.SECONDS);
                subscriptionClient.awaitTermination(5L, TimeUnit.SECONDS);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Topic createTopic(TopicAdminClient topicClient, String topicName, String projectId) {
        Topic topic = Topic.newBuilder().setName(TopicName.of((String)projectId, (String)topicName).toString()).build();
        return topicClient.createTopic(topic);
    }

    private Subscription createSubscription(SubscriptionAdminClient subscriptionClient, Topic topic, String subscriptionName, String projectId) {
        return this.createSubscription(subscriptionClient, topic, subscriptionName, projectId, false);
    }

    private Subscription createSubscription(SubscriptionAdminClient subscriptionClient, Topic topic, String subscriptionName, String projectId, boolean enableOrdering) {
        ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)projectId, (String)subscriptionName);
        Subscription.Builder subscriptionBuilder = Subscription.newBuilder().setName(projectSubscriptionName.toString()).setTopic(topic.getName()).setAckDeadlineSeconds(10);
        if (enableOrdering) {
            subscriptionBuilder = subscriptionBuilder.setEnableMessageOrdering(true);
        }
        return subscriptionClient.createSubscription(subscriptionBuilder.build());
    }

    private FixedTransportChannelProvider createChannelProvider(GoogleCloudContext context) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)String.format("%s:%s", "localhost", this.container.getFirstMappedPort())).usePlaintext().build();
        return FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
    }

    private TopicAdminClient createTopicAdminClient(GoogleCloudContext context) throws IOException {
        if (!context.isUsingMockBackend()) {
            return TopicAdminClient.create();
        }
        FixedTransportChannelProvider channelProvider = this.createChannelProvider(context);
        NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
        try {
            return TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)credentialsProvider)).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SubscriptionAdminClient createSubscriptionAdminClient(GoogleCloudContext context) throws IOException {
        if (!context.isUsingMockBackend()) {
            return SubscriptionAdminClient.create();
        }
        FixedTransportChannelProvider channelProvider = this.createChannelProvider(context);
        NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
        try {
            return SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)credentialsProvider)).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

