/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.github.it;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Path(value="/github")
public class GithubResource {
    private static final String GITHUB_AUTH_PARAMS = "oauthToken={{env:GITHUB_TOKEN:}}";
    @Inject
    ProducerTemplate producerTemplate;

    public void onContextStart(@Observes CamelContextStartedEvent event) {
        Config config = ConfigProvider.getConfig();
        Optional wireMockUrl = config.getOptionalValue("wiremock.url", String.class);
        if (wireMockUrl.isPresent()) {
            try {
                CamelContext context = event.getContext();
                URI wireMockUri = new URI((String)wireMockUrl.get());
                GitHubClient client = new GitHubClient(wireMockUri.getHost(), wireMockUri.getPort(), wireMockUri.getScheme()){

                    protected String configureUri(String uri) {
                        return uri;
                    }
                };
                DataService dataService = new DataService(client);
                RepositoryService repositoryService = new RepositoryService(client);
                context.getRegistry().bind("githubDataService", (Object)dataService);
                context.getRegistry().bind("githubRepositoryService", (Object)repositoryService);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String getCamelQuarkusReadme() throws Exception {
        CommitFile commitFile = new CommitFile();
        commitFile.setSha("6195efafd0a8100795247e35942b5c61fea79267");
        return (String)this.producerTemplate.requestBody("github:GETCOMMITFILE?repoOwner=apache&repoName=camel-quarkus&oauthToken={{env:GITHUB_TOKEN:}}", (Object)commitFile, String.class);
    }
}

