/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.git.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

@QuarkusTest
class GitTest {
    GitTest() {
    }

    @Test
    void initAddCommit() {
        String repoName = "testRepo-" + UUID.randomUUID().toString();
        String path = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).post("/git/init/" + repoName, new Object[0])).then()).statusCode(201)).extract().body().asString();
        Path repoPath = Paths.get(path, new String[0]);
        Assertions.assertThat((Path)repoPath).exists();
        Assertions.assertThat((Path)repoPath.resolve(".git")).exists();
        String file = "foo/bar.txt";
        String fileContent = "foo/bar";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.BINARY).body("foo/bar".getBytes(StandardCharsets.UTF_8)).post("/git/add-and-commit/" + repoName + "/foo/bar.txt", new Object[0])).then()).statusCode(201)).body(Is.is((Object)("target/" + repoName + "/foo/bar.txt")), new Matcher[0]);
        Assertions.assertThat((Path)repoPath).exists();
        Assertions.assertThat((Path)repoPath.resolve("foo/bar.txt")).exists().hasContent("foo/bar");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/git/log/" + repoName, new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Add foo/bar.txt"), new Matcher[0]);
    }
}

