/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.git.it;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;

@Path(value="/git")
@ApplicationScoped
public class GitResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/init/{repoName}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response init(@PathParam(value="repoName") String repoName) throws Exception {
        this.producerTemplate.requestBody("git:target/" + repoName + "?operation=init", null);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)("target/" + repoName)).build();
    }

    @Path(value="/add-and-commit/{repoName}/{file:(.+)?}")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/plain"})
    public Response addAndCommit(@PathParam(value="repoName") String repoName, @PathParam(value="file") String file, byte[] content) throws Exception {
        java.nio.file.Path path = Paths.get("target/" + repoName + "/" + file, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, content, new OpenOption[0]);
        this.producerTemplate.requestBodyAndHeader("git:target/" + repoName + "?operation=add", null, "CamelGitFilename", (Object)file);
        this.producerTemplate.requestBodyAndHeader("git:target/" + repoName + "?operation=commit", null, "CamelGitCommitMessage", (Object)("Add " + file));
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)("target/" + repoName + "/" + file)).build();
    }

    @Path(value="/log/{repoName}")
    @GET
    @Produces(value={"text/plain"})
    public String log(@PathParam(value="repoName") String repoName) throws Exception {
        Iterable it = (Iterable)this.producerTemplate.requestBody("git:target/" + repoName + "?operation=log", null, Iterable.class);
        return StreamSupport.stream(it.spliterator(), false).map(commit -> commit.getName() + " " + commit.getFullMessage()).collect(Collectors.joining("\n"));
    }
}

