/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.geocoder.GeoCoderComponent;
import org.apache.camel.quarkus.component.geocoder.it.MockApiService;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class GeocoderProducers {
    @ConfigProperty(name="google.api.key")
    String googleApiKey;

    @Produces
    @ApplicationScoped
    @Named(value="geocoder")
    GeoCoderComponent geocoderComponent(CamelContext camelContext, MockApiService mockApiService) throws IllegalAccessException, NoSuchFieldException, InstantiationException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Optional wireMockUrl = ConfigProvider.getConfig().getOptionalValue("wiremock.url", String.class);
        GeoCoderComponent result = new GeoCoderComponent();
        result.setCamelContext(camelContext);
        if (wireMockUrl.isPresent()) {
            result.setGeoApiContext(mockApiService.createGeoApiContext((String)wireMockUrl.get(), this.googleApiKey));
        }
        return result;
    }
}

