/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import io.quarkus.runtime.LaunchMode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.geocoder.GeocoderStatus;
import org.apache.camel.quarkus.component.geocoder.it.GeocoderResult;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/nomination")
@ApplicationScoped
public class GeocoderNominationResource {
    private static final Logger LOG = Logger.getLogger(GeocoderNominationResource.class);
    @ConfigProperty(name="quarkus.http.test-port")
    Optional<Integer> httpTestPort;
    @ConfigProperty(name="quarkus.http.port")
    Optional<Integer> httpPort;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="address/{address}")
    @GET
    @Produces(value={"application/json"})
    public GeocoderResult getByCurrentLocation(@PathParam(value="address") String address) throws Exception {
        LOG.infof("Retrieve info from address %s", (Object)address);
        Exchange result = this.producerTemplate.request("geocoder:address:" + address + "?type=NOMINATIM&serverUrl=RAW(" + this.getServerUrl() + ")", exchange -> exchange.getMessage().setBody((Object)"Hello Body"));
        return this.extractResult(result);
    }

    @Path(value="lat/{lat}/lon/{lon}")
    @GET
    @Produces(value={"application/json"})
    public GeocoderResult getByCoordinate(@PathParam(value="lat") String latitude, @PathParam(value="lon") String longitude) throws Exception {
        LOG.infof("Retrieve info from georgraphic coordinates latitude : %s, longitude %s", (Object)latitude, (Object)longitude);
        Exchange result = this.producerTemplate.request("geocoder:latlng:" + latitude + "," + longitude + "?type=NOMINATIM&serverUrl=RAW(" + this.getServerUrl() + ")", exchange -> exchange.getMessage().setBody((Object)"Hello Body"));
        return this.extractResult(result);
    }

    private GeocoderResult extractResult(Exchange exchange) throws Exception {
        Exception exception = exchange.getException();
        if (exception != null) {
            throw exception;
        }
        Message message = exchange.getIn();
        return new GeocoderResult().withLat(this.extractString(message, "CamelGeoCoderLat")).withLng(this.extractString(message, "CamelGeoCoderLng")).withLatLng(this.extractString(message, "CamelGeoCoderLatlng")).withAddress(this.extractString(message, "CamelGeoCoderAddress")).withStatus((GeocoderStatus)message.getHeader("CamelGeoCoderStatus", GeocoderStatus.class)).withCountry(this.extractString(message, "CamelGeoCoderCountryShort"), this.extractString(message, "CamelGeoCoderCountryLong")).withCity(this.extractString(message, "CamelGeoCoderCity")).withPostalCode(this.extractString(message, "CamelGeoCoderPostalCode")).withRegion(this.extractString(message, "CamelGeoCoderRegionCode"), this.extractString(message, "CamelGeoCoderRegionName"));
    }

    private String extractString(Message message, String name) {
        return (String)message.getHeader(name, String.class);
    }

    private String getServerUrl() {
        Config config = ConfigProvider.getConfig();
        Optional wiremockUrl = config.getOptionalValue("wiremock.url", String.class);
        if (wiremockUrl.isPresent()) {
            int port = LaunchMode.current().equals((Object)LaunchMode.TEST) ? this.httpTestPort.get() : this.httpPort.get();
            return String.format("http://localhost:%d/fake/nominatim/api", port);
        }
        return "https://nominatim.openstreetmap.org";
    }
}

