/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.apache.camel.CamelContext;
import org.apache.camel.component.geocoder.GeoCoderComponent;
import org.apache.camel.quarkus.component.geocoder.it.MockApiService;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class GeocoderProducers {
    @ConfigProperty(name="google.api.key")
    String googleApiKey;

    @Produces
    @ApplicationScoped
    @Named(value="geocoder")
    GeoCoderComponent geocoderComponent(CamelContext camelContext, MockApiService mockApiService) throws IllegalAccessException, NoSuchFieldException, InstantiationException {
        Optional wireMockUrl = ConfigProvider.getConfig().getOptionalValue("wiremock.url", String.class);
        GeoCoderComponent result = new GeoCoderComponent();
        result.setCamelContext(camelContext);
        if (wireMockUrl.isPresent()) {
            result.setGeoApiContext(mockApiService.createGeoApiContext((String)wireMockUrl.get(), this.googleApiKey));
        }
        return result;
    }
}

