/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import com.google.maps.model.GeocodingResult;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/google")
@ApplicationScoped
@Produces(value={"application/json"})
public class GeocoderGoogleResource {
    private static final Logger LOG = Logger.getLogger(GeocoderGoogleResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @ConfigProperty(name="google.api.key", defaultValue="AIzaFakeKey")
    String googleApiKey;

    @GET
    public GeocodingResult[] getByCurrentLocation() {
        LOG.infof("Retrieve info from current location", new Object[0]);
        GeocodingResult[] response = (GeocodingResult[])this.producerTemplate.requestBody(String.format("geocoder:address:current?apiKey=%s", this.googleApiKey), null, GeocodingResult[].class);
        LOG.infof("Response : %s", (Object[])response);
        return response;
    }

    @Path(value="address/{address}")
    @GET
    public GeocodingResult[] getByAddress(@PathParam(value="address") String address) {
        LOG.infof("Retrieve info from address : %s", (Object)address);
        GeocodingResult[] response = (GeocodingResult[])this.producerTemplate.requestBody(String.format("geocoder:address:%s?apiKey=%s", address, this.googleApiKey), null, GeocodingResult[].class);
        LOG.infof("Response: %s", (Object[])response);
        return response;
    }

    @Path(value="lat/{lat}/lon/{lon}")
    @GET
    public GeocodingResult[] getByCoordinate(@PathParam(value="lat") String latitude, @PathParam(value="lon") String longitude) {
        LOG.infof("Retrieve  info from georgraphic coordinates latitude : %s, longitude %s", (Object)latitude, (Object)longitude);
        GeocodingResult[] response = (GeocodingResult[])this.producerTemplate.requestBody(String.format("geocoder:latlng:%s,%s?apiKey=%s", latitude, longitude, this.googleApiKey), null, GeocodingResult[].class);
        LOG.infof("Response : %s", (Object[])response);
        return response;
    }
}

