/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.geocoder.it.GeocoderGoogleResource;
import org.apache.camel.quarkus.component.geocoder.it.GeocoderTestResource;
import org.apache.camel.quarkus.test.wiremock.MockServer;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestHTTPEndpoint(value=GeocoderGoogleResource.class)
@QuarkusTestResource(value=GeocoderTestResource.class)
class GeocoderGoogleTest {
    @MockServer
    WireMockServer server;

    GeocoderGoogleTest() {
    }

    @Test
    public void loadCurrentLocation() {
        if (this.server != null) {
            this.server.stubFor(WireMock.request((String)"POST", (UrlPattern)WireMock.urlPathEqualTo((String)"/geolocation/v1/geolocate")).withQueryParam("key", WireMock.matching((String)".*")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"considerIp\": true}")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"location\":{\"lat\":24.7768404,\"lng\":-76.2849047},\"accuracy\":8252}")));
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get().then()).statusCode(200)).body("[0]", Matchers.hasKey((Object)"addressComponents"), new Object[0]);
    }

    @Test
    public void loadAddress() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/address/calle marie curie, sevilla, sevilla", (Object[])new Object[0]).then()).statusCode(200)).body("[0]", Matchers.hasKey((Object)"addressComponents"), new Object[0]);
    }

    @Test
    public void loadLatLong() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/lat/40.714224/lon/-73.961452", (Object[])new Object[0]).then()).statusCode(200)).body("[0]", Matchers.hasKey((Object)"addressComponents"), new Object[0]);
    }
}

