/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import org.apache.camel.component.geocoder.GeocoderStatus;
import org.apache.camel.quarkus.component.geocoder.it.Country;
import org.apache.camel.quarkus.component.geocoder.it.Region;

public class GeocoderResult {
    private GeocoderStatus status;
    private String lat;
    private String lng;
    private String latLng;
    private String address;
    private Country country;
    private String city;
    private String postalCode;
    private Region region;

    public GeocoderResult withLat(String lat) {
        this.lat = lat;
        return this;
    }

    public GeocoderResult withLng(String lng) {
        this.lng = lng;
        return this;
    }

    public GeocoderResult withLatLng(String latLng) {
        this.latLng = latLng;
        return this;
    }

    public GeocoderResult withAddress(String address) {
        this.address = address;
        return this;
    }

    public GeocoderResult withStatus(GeocoderStatus status) {
        this.status = status;
        return this;
    }

    public GeocoderResult withCountry(String shortCode, String longCode) {
        this.country = new Country(shortCode, longCode);
        return this;
    }

    public GeocoderResult withCity(String city) {
        this.city = city;
        return this;
    }

    public GeocoderResult withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public GeocoderResult withRegion(String code, String name) {
        this.region = new Region(code, name);
        return this;
    }

    public GeocoderStatus getStatus() {
        return this.status;
    }

    public String getLat() {
        return this.lat;
    }

    public String getLng() {
        return this.lng;
    }

    public String getLatLng() {
        return this.latLng;
    }

    public String getAddress() {
        return this.address;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getCity() {
        return this.city;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public Region getRegion() {
        return this.region;
    }
}

