/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.geocoder.GeocoderStatus;
import org.apache.camel.quarkus.component.geocoder.it.GeocoderResult;
import org.jboss.logging.Logger;

@Path(value="/nomination")
@ApplicationScoped
public class GeocoderNominationResource {
    private static final Logger LOG = Logger.getLogger(GeocoderNominationResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="address/{address}")
    @GET
    @Produces(value={"application/json"})
    public GeocoderResult getByCurrentLocation(@PathParam(value="address") String address) {
        LOG.infof("Retrieve info from address %s", (Object)address);
        Exchange result = this.producerTemplate.request("geocoder:address:" + address + "?type=NOMINATIM&serverUrl=RAW(https://nominatim.openstreetmap.org)", exchange -> exchange.getMessage().setBody((Object)"Hello Body"));
        return this.extractResult(result);
    }

    @Path(value="lat/{lat}/lon/{lon}")
    @GET
    @Produces(value={"application/json"})
    public GeocoderResult getByCoordinate(@PathParam(value="lat") String latitude, @PathParam(value="lon") String longitude) {
        LOG.infof("Retrieve info from georgraphic coordinates latitude : %s, longitude %s", (Object)latitude, (Object)longitude);
        Exchange result = this.producerTemplate.request("geocoder:latlng:" + latitude + "," + longitude + "?type=NOMINATIM&serverUrl=RAW(https://nominatim.openstreetmap.org)", exchange -> exchange.getMessage().setBody((Object)"Hello Body"));
        return this.extractResult(result);
    }

    private GeocoderResult extractResult(Exchange exchange) {
        Message message = exchange.getIn();
        return new GeocoderResult().withLat(this.extractString(message, "CamelGeoCoderLat")).withLng(this.extractString(message, "CamelGeoCoderLng")).withLatLng(this.extractString(message, "CamelGeoCoderLatlng")).withAddress(this.extractString(message, "CamelGeoCoderAddress")).withStatus((GeocoderStatus)message.getHeader("CamelGeoCoderStatus", GeocoderStatus.class)).withCountry(this.extractString(message, "CamelGeoCoderCountryShort"), this.extractString(message, "CamelGeoCoderCountryLong")).withCity(this.extractString(message, "CamelGeoCoderCity")).withPostalCode(this.extractString(message, "CamelGeoCoderPostalCode")).withRegion(this.extractString(message, "CamelGeoCoderRegionCode"), this.extractString(message, "CamelGeoCoderRegionName"));
    }

    private String extractString(Message message, String name) {
        return (String)message.getHeader(name, String.class);
    }
}

