/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.geocoder.it;

import io.quarkus.arc.Unremovable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.apache.camel.CamelContext;
import org.apache.camel.component.geocoder.GeoCoderComponent;
import org.apache.camel.quarkus.component.geocoder.it.MockApiService;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class GeocoderProducers {
    @ConfigProperty(name="google.api.key")
    String googleApiKey;

    @Produces
    @ApplicationScoped
    @Unremovable
    @Named(value="geocoder")
    GeoCoderComponent geocoderComponent(CamelContext camelContext, MockApiService mockApiService) throws IllegalAccessException, NoSuchFieldException, InstantiationException {
        String wireMockUrl = System.getProperty("wiremock.url");
        GeoCoderComponent result = new GeoCoderComponent();
        result.setCamelContext(camelContext);
        if (wireMockUrl != null) {
            result.setGeoApiContext(mockApiService.createGeoApiContext(wireMockUrl, this.googleApiKey));
        }
        return result;
    }
}

