/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.sftp.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.apache.camel.util.CollectionHelper;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.ClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.jboss.logging.Logger;

public class SftpTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = Logger.getLogger(SftpTestResource.class);
    private static final String KNOWN_HOSTS = "[localhost]:%d ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQDdfIWeSV4o68dRrKSzFd/Bk51E65UTmmSrmW0O1ohtzi6HzsDPjXgCtlTt3FqTcfFfI92IlTr4JWqC9UK1QT1ZTeng0MkPQmv68hDANHbt5CpETZHjW5q4OOgWhVvj5IyOC2NZHtKlJBkdsMAa15ouOOJLzBvAvbqOR/yUROsEiQ==";
    private SshServer sshServer;
    private Path sftpHome;
    private Path sshHome;

    public Map<String, String> start() {
        try {
            int port = AvailablePortFinder.getNextAvailable();
            this.sftpHome = Files.createTempDirectory("sftp-", new FileAttribute[0]);
            this.sshHome = this.sftpHome.resolve("admin/.ssh");
            Files.createDirectories(this.sshHome, new FileAttribute[0]);
            byte[] knownHostsBytes = String.format(KNOWN_HOSTS, port).getBytes(StandardCharsets.UTF_8);
            Files.write(this.sshHome.resolve(".known_hosts"), knownHostsBytes, new OpenOption[0]);
            VirtualFileSystemFactory factory = new VirtualFileSystemFactory();
            factory.setUserHomeDir("admin", this.sftpHome.resolve("admin").toAbsolutePath());
            this.sshServer = SshServer.setUpDefaultServer();
            this.sshServer.setPort(port);
            this.sshServer.setKeyPairProvider((KeyPairProvider)new ClassLoadableResourceKeyPairProvider("hostkey.pem"));
            this.sshServer.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
            this.sshServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
            this.sshServer.setPasswordAuthenticator((username, password, session) -> true);
            this.sshServer.setPublickeyAuthenticator((username, key, session) -> true);
            this.sshServer.setFileSystemFactory((FileSystemFactory)factory);
            this.sshServer.start();
            return CollectionHelper.mapOf((Object)"camel.sftp.test-port", (Object)Integer.toString(port), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        block11: {
            try {
                if (this.sshServer != null) {
                    this.sshServer.stop();
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to stop FTP server due to {}", (Throwable)e);
            }
            try {
                if (this.sftpHome == null) break block11;
                try (Stream<Path> files = Files.walk(this.sftpHome, new FileVisitOption[0]);){
                    files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed delete sftp home: {}, {}", (Object)this.sftpHome, (Throwable)e);
            }
        }
        AvailablePortFinder.releaseReservedPorts();
    }
}

