/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ftp.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.apache.camel.util.CollectionHelper;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.jboss.logging.Logger;

public class FtpTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = Logger.getLogger(FtpTestResource.class);
    private final String componentName;
    private FtpServer ftpServer;
    private Path ftpRoot;
    private Path usrFile;

    public FtpTestResource() {
        this("ftp");
    }

    public FtpTestResource(String componentName) {
        this.componentName = componentName;
    }

    public Map<String, String> start() {
        try {
            int port = AvailablePortFinder.getNextAvailable();
            this.ftpRoot = Files.createTempDirectory("ftp-", new FileAttribute[0]);
            this.usrFile = Files.createTempFile("ftp-", ".properties", new FileAttribute[0]);
            NativeFileSystemFactory fsf = new NativeFileSystemFactory();
            fsf.setCreateHome(true);
            PropertiesUserManagerFactory pumf = new PropertiesUserManagerFactory();
            pumf.setAdminName("admin");
            pumf.setPasswordEncryptor((PasswordEncryptor)new ClearTextPasswordEncryptor());
            pumf.setFile(this.usrFile.toFile());
            UserManager userMgr = pumf.createUserManager();
            BaseUser user = new BaseUser();
            user.setName("admin");
            user.setPassword("admin");
            user.setHomeDirectory(this.ftpRoot.toString());
            ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
            WritePermission writePermission = new WritePermission();
            writePermission.authorize((AuthorizationRequest)new WriteRequest());
            authorities.add(writePermission);
            user.setAuthorities(authorities);
            userMgr.save((User)user);
            ListenerFactory factory = this.createListenerFactory(port);
            FtpServerFactory serverFactory = new FtpServerFactory();
            serverFactory.setUserManager(userMgr);
            serverFactory.setFileSystem((FileSystemFactory)fsf);
            serverFactory.setConnectionConfig(new ConnectionConfigFactory().createConnectionConfig());
            serverFactory.addListener("default", factory.createListener());
            FtpServerFactory ftpServerFactory = serverFactory;
            this.ftpServer = ftpServerFactory.createServer();
            this.ftpServer.start();
            return CollectionHelper.mapOf((Object)("camel." + this.componentName + ".test-port"), (Object)Integer.toString(port), (Object[])new Object[]{"camel." + this.componentName + ".test-root-dir", this.ftpRoot.toString(), "camel." + this.componentName + ".test-user-file", this.usrFile.toString()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        block14: {
            try {
                if (this.ftpServer != null) {
                    this.ftpServer.stop();
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to stop FTP server due to {}", (Throwable)e);
            }
            try {
                if (this.ftpRoot == null) break block14;
                try (Stream<Path> files = Files.walk(this.ftpRoot, new FileVisitOption[0]);){
                    files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed delete ftp root: {}, {}", (Object)this.ftpRoot, (Throwable)e);
            }
        }
        try {
            if (this.usrFile != null) {
                Files.deleteIfExists(this.usrFile);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed delete usr file: {}, {}", (Object)this.usrFile, (Throwable)e);
        }
        AvailablePortFinder.releaseReservedPorts();
    }

    protected ListenerFactory createListenerFactory(int port) {
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(port);
        return factory;
    }
}

