/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.sftp.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;

@Path(value="/sftp")
@ApplicationScoped
public class SftpResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/get/{fileName}")
    @GET
    @Produces(value={"text/plain"})
    public String getFile(@PathParam(value="fileName") String fileName) throws Exception {
        return (String)this.consumerTemplate.receiveBodyNoWait("sftp://admin@localhost:{{camel.sftp.test-port}}/sftp?password=admin&localWorkDirectory=target&fileName=" + fileName, String.class);
    }

    @Path(value="/create/{fileName}")
    @POST
    @Consumes(value={"text/plain"})
    public Response createFile(@PathParam(value="fileName") String fileName, String fileContent) throws Exception {
        this.producerTemplate.sendBodyAndHeader("sftp://admin@localhost:{{camel.sftp.test-port}}/sftp?password=admin", (Object)fileContent, "CamelFileName", (Object)fileName);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

