/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.freemarker.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collections;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.freemarker.it.MyPerson;

@Path(value="/freemarker")
@ApplicationScoped
public class FreemarkerResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/freemarkerLetter")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String freemarkerLetter() throws Exception {
        return (String)this.producerTemplate.request("freemarker:org/apache/camel/component/freemarker/example.ftl?allowContextMapAll=true", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Monday");
                exchange.getIn().setHeader("name", (Object)"Christian");
                exchange.setProperty("item", (Object)"7");
            }
        }).getMessage().getBody(String.class);
    }

    @Path(value="/freemarkerDataModel")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String freemarkerDataModel() throws Exception {
        return (String)this.producerTemplate.request("freemarker:org/apache/camel/component/freemarker/example.ftl?allowTemplateFromHeader=true", new Processor(){

            public void process(Exchange exchange) throws Exception {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("headers", Collections.singletonMap("name", "Willem"));
                model.put("body", "Monday");
                model.put("exchange", Collections.singletonMap("properties", Collections.singletonMap("item", "7")));
                exchange.getIn().setHeader("CamelFreemarkerDataModel", model);
            }
        }).getMessage().getBody(String.class);
    }

    @Path(value="/valuesInProperties")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String valuesInProperties() throws Exception {
        return (String)this.producerTemplate.request("freemarker:dummy?allowTemplateFromHeader=true&allowContextMapAll=true", exchange1 -> {
            exchange1.getIn().setHeader("CamelFreemarkerTemplate", (Object)"Dear ${exchange.properties.name}. You ordered item ${exchange.properties.item}.");
            exchange1.setProperty("name", (Object)"Christian");
            exchange1.setProperty("item", (Object)"7");
        }).getMessage().getBody(String.class);
    }

    @Path(value="/templateInHeader")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String templateInHeader(String body) throws Exception {
        return (String)this.producerTemplate.requestBodyAndHeader("freemarker://dummy?allowTemplateFromHeader=true", (Object)body, "CamelFreemarkerTemplate", (Object)"Hello ${body}!", String.class);
    }

    @Path(value="/bodyAsDomainObject/{firstName}/{lastName}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String bodyAsDomainObject(@PathParam(value="firstName") String firstName, @PathParam(value="lastName") String lastName) throws Exception {
        return (String)this.producerTemplate.requestBody("freemarker:folder/subfolder/templates/BodyAsDomainObject.ftl", (Object)new MyPerson(firstName, lastName), String.class);
    }
}

