/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.flatpack.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class FlatpackTest {
    FlatpackTest() {
    }

    @Test
    public void delimitedUnmarshalShouldSucceed() throws IOException {
        String data = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/INVENTORY-CommaDelimitedWithQualifier.txt"), (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(data).when().get("/flatpack/delimited-unmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"4-SOME VALVE"), new Matcher[0]);
    }

    @Test
    public void delimitedMarshalShouldSucceed() {
        ArrayList data = new ArrayList();
        LinkedHashMap<String, String> firstRow = new LinkedHashMap<String, String>();
        firstRow.put("ITEM_DESC", "SOME VALVE");
        firstRow.put("IN_STOCK", "2");
        firstRow.put("PRICE", "5.00");
        firstRow.put("LAST_RECV_DT", "20050101");
        data.add(firstRow);
        LinkedHashMap<String, String> secondRow = new LinkedHashMap<String, String>();
        secondRow.put("ITEM_DESC", "AN ENGINE");
        secondRow.put("IN_STOCK", "100");
        secondRow.put("PRICE", "1000.00");
        secondRow.put("LAST_RECV_DT", "20040601");
        data.add(secondRow);
        String expected = "ITEM_DESC,IN_STOCK,PRICE,LAST_RECV_DT\nAN ENGINE,100,1000.00,20040601\n";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(data).when().get("/flatpack/delimited-marshal", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void fixedLengthUnmarshalShouldSucceed() throws IOException {
        String data = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/PEOPLE-FixedLength.txt"), (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(data).when().get("/flatpack/fixed-length-unmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"4-JOHN"), new Matcher[0]);
    }

    @Test
    public void fixedLengthMarshalShouldSucceed() {
        ArrayList data = new ArrayList();
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        row.put("FIRSTNAME", "JOHN");
        row.put("LASTNAME", "DOE");
        row.put("ADDRESS", "1234 CIRCLE CT");
        row.put("CITY", "ELYRIA");
        row.put("STATE", "OH");
        row.put("ZIP", "44035");
        data.add(row);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(data).when().get("/flatpack/fixed-length-marshal", new Object[0])).then()).statusCode(200)).body(Matchers.startsWith((String)"JOHN                               DOE"), new Matcher[0]);
    }

    @Test
    public void delimitedShouldSucceed() throws IOException {
        String data = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/INVENTORY-CommaDelimitedWithQualifier.txt"), (Charset)StandardCharsets.UTF_8);
        Map[] rows = (Map[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(data).when().get("/flatpack/delimited", new Object[0])).then()).statusCode(200)).extract().as(Map[].class);
        Assertions.assertNotNull((Object)rows);
        Assertions.assertEquals((int)4, (int)rows.length);
        Assertions.assertNotNull((Object)rows[0]);
        Assertions.assertEquals((Object)"SOME VALVE", rows[0].get("ITEM_DESC"));
        Assertions.assertNotNull((Object)rows[1]);
        Assertions.assertEquals((Object)"AN ENGINE", rows[1].get("ITEM_DESC"));
        Assertions.assertNotNull((Object)rows[2]);
        Assertions.assertEquals((Object)"A BELT", rows[2].get("ITEM_DESC"));
        Assertions.assertNotNull((Object)rows[3]);
        Assertions.assertEquals((Object)"A BOLT", rows[3].get("ITEM_DESC"));
    }

    @Test
    public void fixedShouldSucceed() throws IOException {
        String data = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/PEOPLE-FixedLength.txt"), (Charset)StandardCharsets.UTF_8);
        Map[] rows = (Map[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(data).when().get("/flatpack/fixed", new Object[0])).then()).statusCode(200)).extract().as(Map[].class);
        Assertions.assertNotNull((Object)rows);
        Assertions.assertEquals((int)4, (int)rows.length);
        Assertions.assertNotNull((Object)rows[0]);
        Assertions.assertEquals((Object)"JOHN", rows[0].get("FIRSTNAME"));
        Assertions.assertNotNull((Object)rows[1]);
        Assertions.assertEquals((Object)"JIMMY", rows[1].get("FIRSTNAME"));
        Assertions.assertNotNull((Object)rows[2]);
        Assertions.assertEquals((Object)"JANE", rows[2].get("FIRSTNAME"));
        Assertions.assertNotNull((Object)rows[3]);
        Assertions.assertEquals((Object)"FRED", rows[3].get("FIRSTNAME"));
    }

    @Test
    public void fixedHeaderAndTrailerShouldSucceed() throws IOException {
        String data = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/PEOPLE-HeaderAndTrailer.txt"), (Charset)StandardCharsets.UTF_8);
        Map[] rows = (Map[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(data).when().get("/flatpack/headerAndTrailer", new Object[0])).then()).statusCode(200)).extract().as(Map[].class);
        Assertions.assertNotNull((Object)rows);
        Assertions.assertEquals((int)6, (int)rows.length);
        Assertions.assertNotNull((Object)rows[0]);
        Assertions.assertEquals((Object)"HBT", rows[0].get("INDICATOR"));
        Assertions.assertEquals((Object)"20080817", rows[0].get("DATE"));
        Assertions.assertNotNull((Object)rows[1]);
        Assertions.assertEquals((Object)"JOHN", rows[1].get("FIRSTNAME"));
        Assertions.assertNotNull((Object)rows[2]);
        Assertions.assertEquals((Object)"JIMMY", rows[2].get("FIRSTNAME"));
        Assertions.assertNotNull((Object)rows[3]);
        Assertions.assertEquals((Object)"JANE", rows[3].get("FIRSTNAME"));
        Assertions.assertNotNull((Object)rows[4]);
        Assertions.assertEquals((Object)"FRED", rows[4].get("FIRSTNAME"));
        Assertions.assertNotNull((Object)rows[5]);
        Assertions.assertEquals((Object)"FBT", rows[5].get("INDICATOR"));
        Assertions.assertEquals((Object)"SUCCESS", rows[5].get("STATUS"));
    }

    @Test
    public void noDescriptorShouldSucceed() throws IOException {
        String data = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/foo.csv"), (Charset)StandardCharsets.UTF_8);
        Map[] rows = (Map[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(data).when().get("/flatpack/noDescriptor", new Object[0])).then()).statusCode(200)).extract().as(Map[].class);
        Assertions.assertNotNull((Object)rows);
        Assertions.assertEquals((int)4, (int)rows.length);
        Assertions.assertNotNull((Object)rows[0]);
        Assertions.assertEquals((Object)"James", rows[0].get("NAME"));
        Assertions.assertNotNull((Object)rows[1]);
        Assertions.assertEquals((Object)"Claus", rows[1].get("NAME"));
        Assertions.assertNotNull((Object)rows[2]);
        Assertions.assertEquals((Object)"Antoine", rows[2].get("NAME"));
        Assertions.assertNotNull((Object)rows[3]);
        Assertions.assertEquals((Object)"Xavier", rows[3].get("NAME"));
    }

    @Test
    public void invalidShouldFail() throws IOException {
        String data = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/PEOPLE-FixedLength-Invalid.txt"), (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(data).when().get("/flatpack/invalid", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Flatpack has found 4 errors while parsing."), new Matcher[0])).body(Matchers.containsString((String)"Line:4 Level:2 Desc:LINE TOO LONG. LINE IS 278 LONG. SHOULD BE 277"), new Matcher[0]);
    }
}

