/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.flatpack.it;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.flatpack.DataSetList;
import org.jboss.logging.Logger;

@Path(value="/flatpack")
@ApplicationScoped
public class FlatpackResource {
    private static final Logger LOG = Logger.getLogger(FlatpackResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/delimited-unmarshal")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String delimitedUnmarshal(String data) {
        LOG.infof("Invoking delimitedUnmarshal with data: %s", (Object)data);
        DataSetList unmarshalled = (DataSetList)this.producerTemplate.requestBody("direct:delimited-unmarshal", (Object)data, DataSetList.class);
        return unmarshalled.size() + "-" + unmarshalled.get(0).get("ITEM_DESC");
    }

    @Path(value="/delimited-marshal")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String delimitedMarshal(List<Map<String, String>> object) {
        LOG.infof("Invoking delimitedMarshal with object: %s", object);
        return (String)this.producerTemplate.requestBody("direct:delimited-marshal", object, String.class);
    }

    @Path(value="/fixed-length-unmarshal")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String fixedLengthUnmarshal(String data) {
        LOG.infof("Invoking fixedLengthUnmarshal with data: %s", (Object)data);
        DataSetList unmarshalled = (DataSetList)this.producerTemplate.requestBody("direct:fixed-length-unmarshal", (Object)data, DataSetList.class);
        return unmarshalled.size() + "-" + unmarshalled.get(0).get("FIRSTNAME");
    }

    @Path(value="/fixed-length-marshal")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String fixedLengthMarshal(List<Map<String, String>> object) {
        LOG.infof("Invoking fixedLengthMarshal with object: %s", object);
        return (String)this.producerTemplate.requestBody("direct:fixed-length-marshal", object, String.class);
    }

    @Path(value="/delimited")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public LinkedList<?> delimited(String data) {
        LOG.infof("Invoking delimited with data: %s", (Object)data);
        return (LinkedList)this.producerTemplate.requestBody("direct:delimited", (Object)data, LinkedList.class);
    }

    @Path(value="/fixed")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public LinkedList<?> fixed(String data) {
        LOG.infof("Invoking fixed with data: %s", (Object)data);
        return (LinkedList)this.producerTemplate.requestBody("direct:fixed", (Object)data, LinkedList.class);
    }

    @Path(value="/headerAndTrailer")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public LinkedList<?> headerAndTrailer(String data) {
        LOG.infof("Invoking headerAndTrailer with data: %s", (Object)data);
        return (LinkedList)this.producerTemplate.requestBody("direct:header-and-trailer", (Object)data, LinkedList.class);
    }

    @Path(value="/noDescriptor")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public LinkedList<?> noDescriptor(String data) {
        LOG.infof("Invoking noDescriptor with data: %s", (Object)data);
        return (LinkedList)this.producerTemplate.requestBody("direct:no-descriptor", (Object)data, LinkedList.class);
    }

    @Path(value="/invalid")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String invalid(String data) {
        LOG.infof("Invoking invalid with data: %s", (Object)data);
        return (String)this.producerTemplate.requestBody("direct:fixed", (Object)data, String.class);
    }
}

