/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.flatpack.it;

import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.flatpack.FlatpackException;
import org.apache.camel.dataformat.flatpack.FlatpackDataFormat;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;

public class FlatPackRoutes
extends RouteBuilder {
    public void configure() {
        FlatpackRowStore flatpackRowStore = new FlatpackRowStore();
        this.bindToRegistry("flatpackRowStore", flatpackRowStore);
        this.onException(FlatpackException.class).maximumRedeliveries(1).handled(true).process(e -> {
            FlatpackException cause = (FlatpackException)e.getProperty("CamelExceptionCaught", FlatpackException.class);
            e.getMessage().setBody((Object)cause.getMessage());
        });
        FlatpackDataFormat delimitedDataFormat = new FlatpackDataFormat();
        delimitedDataFormat.setDefinition("INVENTORY-Delimited.pzmap.xml");
        this.from("direct:delimited-unmarshal").unmarshal((DataFormat)delimitedDataFormat);
        this.from("direct:delimited-marshal").marshal((DataFormat)delimitedDataFormat);
        FlatpackDataFormat fixedLengthDataFormat = new FlatpackDataFormat();
        fixedLengthDataFormat.setDefinition("PEOPLE-FixedLength.pzmap.xml");
        fixedLengthDataFormat.setFixed(true);
        fixedLengthDataFormat.setIgnoreFirstRecord(false);
        this.from("direct:fixed-length-unmarshal").unmarshal((DataFormat)fixedLengthDataFormat);
        this.from("direct:fixed-length-marshal").marshal((DataFormat)fixedLengthDataFormat);
        ((RouteDefinition)this.from("direct:delimited").to("flatpack:delim:INVENTORY-Delimited.pzmap.xml")).bean((Object)flatpackRowStore, "flush");
        this.from("flatpack:delim:INVENTORY-Delimited.pzmap.xml").bean((Object)flatpackRowStore, "store");
        ((RouteDefinition)this.from("direct:fixed").to("flatpack:fixed:PEOPLE-FixedLength.pzmap.xml")).bean((Object)flatpackRowStore, "flush");
        this.from("flatpack:fixed:PEOPLE-FixedLength.pzmap.xml").bean((Object)flatpackRowStore, "store");
        ((RouteDefinition)this.from("direct:header-and-trailer").to("flatpack:fixed:PEOPLE-HeaderAndTrailer.pzmap.xml")).bean((Object)flatpackRowStore, "flush");
        this.from("flatpack:fixed:PEOPLE-HeaderAndTrailer.pzmap.xml").bean((Object)flatpackRowStore, "store");
        ((RouteDefinition)this.from("direct:no-descriptor").to("flatpack:foo")).bean((Object)flatpackRowStore, "flush");
        this.from("flatpack:foo").bean((Object)flatpackRowStore, "store");
    }

    @RegisterForReflection
    public static class FlatpackRowStore {
        List<Map<?, ?>> rows = new LinkedList();

        public void store(Map<?, ?> m) {
            this.rows.add(m);
        }

        public List<Map<?, ?>> flush() {
            List<Map<?, ?>> current = this.rows;
            this.rows = new LinkedList();
            return current;
        }
    }
}

