/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class NonFlakyFileTestResource
implements QuarkusTestResourceLifecycleManager {
    static final Path TEST_FILES_FOLDER = Paths.get("target", "test-files");
    static final String FILTER_NON_SKIPPED_FILE_NAME = "non-skipped-file";
    static final String FILTER_NON_SKIPPED_FILE_CONTENT = "non-skipped-file-CONTENT";
    static final String IDEMPOTENT_FILE_NAME = "moved-back-read-once";
    static final String IDEMPOTENT_FILE_CONTENT = "moved-back-read-once-CONTENT";
    static final String POLL_ENRICH_FILE_NAME = "poll-enrich-file";
    static final String POLL_ENRICH_FILE_CONTENT = "poll-enrich-file-CONTENT";
    static final String QUARTZ_SCHEDULED_FILE_NAME = "quartz-schedule-file";
    static final String QUARTZ_SCHEDULED_FILE_CONTENT = "quartz-schedule-file-CONTENT";
    static final String CHARSET_READ_FILE_NAME = "charset-read-file";
    static final String CHARSET_READ_FILE_CONTENT = "A string with \u00f0 char to be read";
    static final String CHARSET_WRITE_FILE_CREATION_FOLDER = "charset-write";
    static final String CHARSET_WRITE_FILE_NAME = "charset-write-file";
    static final String CHARSET_WRITE_FILE_CONTENT = "A string with \u00f0 char to be written";
    static final String FILE_CREATION_FOLDER = "file-creation";
    static final String FILE_CREATION_FILE_NAME = "should-be-created";
    static final String FILE_CREATION_FILE_CONTENT = "should-be-created-CONTENT";
    private final Map<Path, byte[]> createdTestFilesExpectedContent = new HashMap<Path, byte[]>();

    public Map<String, String> start() {
        try {
            FileUtils.deleteDirectory((File)TEST_FILES_FOLDER.toFile());
            this.createTestFile("filter", FILTER_NON_SKIPPED_FILE_NAME);
            this.createTestFile("filter", "skipped_file");
            this.createTestFile("idempotent", IDEMPOTENT_FILE_NAME);
            this.createTestFile("poll-enrich", POLL_ENRICH_FILE_NAME);
            this.createTestFile("quartz-scheduled", QUARTZ_SCHEDULED_FILE_NAME);
            this.createTestFile("charset-read", CHARSET_READ_FILE_NAME, CHARSET_READ_FILE_CONTENT, StandardCharsets.ISO_8859_1);
            this.ensureAllTestFilesCreatedWithExpectedContent();
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem while initializing test files", ex);
        }
        return null;
    }

    private void createTestFile(String testName, String testFileName, String content, Charset charset) throws IOException {
        Path testFilePath = TEST_FILES_FOLDER.resolve(Paths.get(testName, testFileName));
        byte[] contentBytes = content.getBytes(charset);
        FileUtils.writeByteArrayToFile((File)testFilePath.toFile(), (byte[])contentBytes);
        this.createdTestFilesExpectedContent.put(testFilePath, contentBytes);
    }

    private void createTestFile(String testName, String testFileName) throws IOException {
        this.createTestFile(testName, testFileName, testFileName + "-CONTENT", StandardCharsets.UTF_8);
    }

    private void ensureAllTestFilesCreatedWithExpectedContent() {
        for (Map.Entry<Path, byte[]> createdTestFileExpectedContent : this.createdTestFilesExpectedContent.entrySet()) {
            Path path = createdTestFileExpectedContent.getKey();
            try {
                byte[] content = FileUtils.readFileToByteArray((File)path.toFile());
                byte[] expectedContent = createdTestFileExpectedContent.getValue();
                if (Arrays.equals(expectedContent, content)) continue;
                String format = "The NonFlakyFileTestResource failed to create the test file %s with expected content";
                throw new RuntimeException(String.format(format, path));
            }
            catch (IOException ioex) {
                String format = "The NonFlakyFileTestResource has exception while creating the test file %s with expected content";
                throw new RuntimeException(String.format(format, path), ioex);
            }
        }
    }

    public void stop() {
    }
}

