/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.file.it.NonFlakyFileTestResource;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=NonFlakyFileTestResource.class)
class NonFlakyFileTest {
    NonFlakyFileTest() {
    }

    @Test
    void idempotentFileShouldBeReadOnlyOnce() throws IOException, InterruptedException {
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/idempotent_moved-back-read-once_was-read-once", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"moved-back-read-once-CONTENT"));
        Path donePath = NonFlakyFileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("idempotent", "done", "moved-back-read-once"));
        Path targetPath = donePath.getParent().getParent().resolve("moved-back-read-once");
        Files.move(donePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        Thread.sleep(1000L);
        String result = ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/idempotent_moved-back-read-once_was-read-more-than-once", (Object[])new Object[0]).then()).extract().asString();
        Assertions.assertNotEquals((Object)"moved-back-read-once-CONTENT", (Object)result);
    }

    @Test
    void filterShouldReadOnlyMatchingFile() {
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/filter", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"non-skipped-file-CONTENT"));
    }

    @Test
    public void pollEnrichShouldSetExchangeBodyWithFileContent() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).post("/file/route/pollEnrich", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"poll-enrich-file-CONTENT"), new Matcher[0]);
    }

    @Test
    public void quartzScheduledFilePollingShouldSucceed() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/quartzScheduledFilePolling", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"quartz-schedule-file-CONTENT"));
    }

    @Test
    public void createFileShouldSucceed() throws IOException {
        String charset = "UTF-8";
        Path expectedFilePath = NonFlakyFileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("file-creation", "should-be-created"));
        Assertions.assertFalse((boolean)Files.exists(expectedFilePath, new LinkOption[0]));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("should-be-created-CONTENT").queryParam("folder", new Object[]{"file-creation"}).queryParam("charset", new Object[]{charset}).queryParam("fileName", new Object[]{"should-be-created"}).post("/file/create-file", new Object[0])).then()).statusCode(201);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> Files.exists(expectedFilePath, new LinkOption[0]));
        Assertions.assertEquals((Object)"should-be-created-CONTENT", (Object)FileUtils.readFileToString((File)expectedFilePath.toFile(), (String)charset));
    }

    @Test
    void readFileWithIso8859_1CharsetShouldSucceed() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/charsetIsoRead", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"A string with \u00f0 char to be read"));
    }

    @Test
    void writeFileWithIso8859_1CharsetShouldSucceed() throws IOException {
        String charset = "ISO-8859-1";
        Path expectedFilePath = NonFlakyFileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("charset-write", "charset-write-file"));
        Assertions.assertFalse((boolean)Files.exists(expectedFilePath, new LinkOption[0]));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("A string with \u00f0 char to be written").queryParam("folder", new Object[]{"charset-write"}).queryParam("charset", new Object[]{charset}).queryParam("fileName", new Object[]{"charset-write-file"}).post("/file/create-file", new Object[0])).then()).statusCode(201);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> Files.exists(expectedFilePath, new LinkOption[0]));
        Assertions.assertEquals((Object)"A string with \u00f0 char to be written", (Object)FileUtils.readFileToString((File)expectedFilePath.toFile(), (String)charset));
    }
}

