/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.quarkus.component.file.it.FileTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Test;

@QuarkusTest
class FileLanguageTest {
    private static final String FILE_BODY = "Hello Camel Quarkus";

    FileLanguageTest() {
    }

    @Test
    public void fileLanguageExt() throws UnsupportedEncodingException, InterruptedException {
        String txtFileName = FileTest.createFile(FILE_BODY, "/file/create/file-lang-txt-in", null, "in.txt");
        String xmlFileName = FileTest.createFile(FILE_BODY, "/file/create/file-lang-txt-in", null, "in.xml");
        FileTest.startRouteAndWait("fileLanguage_txt");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/file/get/file-lang-txt-out/" + Paths.get(txtFileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(200)).body(IsEqual.equalTo((Object)FILE_BODY), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)("/file/get/file-lang-txt-out/" + Paths.get(xmlFileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void fileLanguageDate() throws UnsupportedEncodingException, InterruptedException {
        FileTest.createFile(FILE_BODY, "/file/create/file-lang-date-in", null, "in.xml");
        FileTest.startRouteAndWait("fileLanguage_date");
        SimpleDateFormat format = new SimpleDateFormat();
        format.applyPattern("yyyyMMdd");
        String fileName = "out-" + format.format(new Date()) + "-customValue.xml";
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/file/get/file-lang-date-out/" + Paths.get(fileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(200)).body(IsEqual.equalTo((Object)FILE_BODY), new Matcher[0]);
    }
}

