/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.file.it.FileResource;
import org.apache.camel.quarkus.component.file.it.FileTestResource;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=FileTestResource.class)
class FileTest {
    FileTest() {
    }

    @Test
    void idempotentFileShouldBeReadOnlyOnce() throws IOException, InterruptedException {
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/idempotent_moved-back-read-once_was-read-once", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"moved-back-read-once-CONTENT"));
        Path donePath = FileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("idempotent", "done", "moved-back-read-once"));
        Path targetPath = donePath.getParent().getParent().resolve("moved-back-read-once");
        Files.move(donePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        Thread.sleep(1000L);
        String result = ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/idempotent_moved-back-read-once_was-read-more-than-once", (Object[])new Object[0]).then()).extract().asString();
        Assertions.assertNotEquals((Object)"moved-back-read-once-CONTENT", (Object)result);
    }

    @Test
    void filterShouldReadOnlyMatchingFile() {
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/filter", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"non-skipped-file-CONTENT"));
    }

    @Test
    public void pollEnrichShouldSetExchangeBodyWithFileContent() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).post("/file/route/pollEnrich", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"poll-enrich-file-CONTENT"), new Matcher[0]);
    }

    @Test
    public void quartzScheduledFilePollingShouldSucceed() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/quartzScheduledFilePolling", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"quartz-schedule-file-CONTENT"));
    }

    @Test
    public void createFileShouldSucceed() throws IOException {
        String charset = "UTF-8";
        Path expectedFilePath = FileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("file-creation", "should-be-created"));
        Assertions.assertFalse((boolean)Files.exists(expectedFilePath, new LinkOption[0]));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("should-be-created-CONTENT").queryParam("folder", new Object[]{"file-creation"}).queryParam("charset", new Object[]{charset}).queryParam("fileName", new Object[]{"should-be-created"}).post("/file/create-file", new Object[0])).then()).statusCode(201);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> Files.exists(expectedFilePath, new LinkOption[0]));
        Assertions.assertEquals((Object)"should-be-created-CONTENT", (Object)FileUtils.readFileToString((File)expectedFilePath.toFile(), (String)charset));
    }

    @Test
    void readFileWithIso8859_1CharsetShouldSucceed() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/charsetIsoRead", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)"A string with \u00f0 char to be read"));
    }

    @Test
    void writeFileWithIso8859_1CharsetShouldSucceed() throws IOException {
        String charset = "ISO-8859-1";
        Path expectedFilePath = FileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("charset-write", "charset-write-file"));
        Assertions.assertFalse((boolean)Files.exists(expectedFilePath, new LinkOption[0]));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("A string with \u00f0 char to be written").queryParam("folder", new Object[]{"charset-write"}).queryParam("charset", new Object[]{charset}).queryParam("fileName", new Object[]{"charset-write-file"}).post("/file/create-file", new Object[0])).then()).statusCode(201);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> Files.exists(expectedFilePath, new LinkOption[0]));
        Assertions.assertEquals((Object)"A string with \u00f0 char to be written", (Object)FileUtils.readFileToString((File)expectedFilePath.toFile(), (String)charset));
    }

    @Test
    void readLockCantBeAcquiredOnFileSmallerThanReadLockMinLength() throws InterruptedException {
        Path inputFilePath = FileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("read-lock-in", "read-lock-file"));
        Path doneFilePath = FileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("read-lock-in", ".done", "read-lock-file"));
        Path outputFilePath = FileTestResource.TEST_FILES_FOLDER.resolve(Paths.get("read-lock-out", "read-lock-file"));
        Thread.sleep(10000L);
        Assertions.assertTrue((boolean)Files.exists(inputFilePath, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(doneFilePath, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(outputFilePath, new LinkOption[0]));
    }

    @Test
    void twoFilesShouldBeReadInSameBatch() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> {
            Map records = (Map)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/file/getBatch/", (Object[])new Object[0]).then()).statusCode(200)).extract().as(Map.class);
            return records.size() == 2 && records.keySet().contains("batch-file-1-CONTENT") && records.keySet().contains("batch-file-2-CONTENT") && records.values().contains(0) && records.values().contains(1);
        });
    }

    @Test
    void filesCreatedInWrongOrderShouldBeSortedByReverseFilename() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)("/file/getFromMock/" + FileResource.SORT_BY), (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)("sortby-file-3-CONTENT" + FileResource.SEPARATOR + "sortby-file-2-CONTENT" + FileResource.SEPARATOR + "sortby-file-1-CONTENT")));
    }

    @Test
    public void fileWatchShouldCatchCreateModifyAndDeleteEvents() throws IOException {
        Path fileWatchDirectory = Files.createTempDirectory(FileTest.class.getSimpleName(), new FileAttribute[0]).toRealPath(new LinkOption[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("path", new Object[]{fileWatchDirectory.toString()}).get("/file-watch/get-events", new Object[0])).then()).statusCode(204);
        Path watchedFilePath = fileWatchDirectory.resolve("watched-file.txt");
        Files.write(watchedFilePath, "a file content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileTest.awaitEvent(fileWatchDirectory, watchedFilePath, "CREATE");
        Files.write(watchedFilePath, "changed content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileTest.awaitEvent(fileWatchDirectory, watchedFilePath, "MODIFY");
        Files.delete(watchedFilePath);
        FileTest.awaitEvent(fileWatchDirectory, watchedFilePath, "DELETE");
    }

    private static void awaitEvent(Path fileWatchDirectory, Path watchedFile, String extepecteEventType) {
        Awaitility.await().pollInterval(100L, TimeUnit.MILLISECONDS).atMost(20L, TimeUnit.SECONDS).until(() -> {
            ValidatableResponse getEventsResponse = (ValidatableResponse)((Response)RestAssured.given().queryParam("path", new Object[]{fileWatchDirectory.toString()}).get("/file-watch/get-events", new Object[0])).then();
            switch (getEventsResponse.extract().statusCode()) {
                case 204: {
                    return false;
                }
                case 200: {
                    JsonPath json = getEventsResponse.extract().jsonPath();
                    String expectedPath = org.apache.camel.quarkus.core.util.FileUtils.nixifyPath((Path)watchedFile);
                    String actualPath = json.getString("path");
                    return expectedPath.equals(actualPath) && extepecteEventType.equals(json.getString("type"));
                }
            }
            throw new RuntimeException("Unexpected status code " + getEventsResponse.extract().statusCode());
        });
    }
}

