/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.quarkus.core.util.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Test;

@QuarkusTest
class FileLanguageTest {
    private static final String FILE_BODY = "Hello Camel Quarkus";

    FileLanguageTest() {
    }

    @Test
    public void fileLanguageExt() throws UnsupportedEncodingException, InterruptedException {
        String txtFileName = FileLanguageTest.createFile(FILE_BODY, "/file/create/file-lang-txt-in", null, "in.txt");
        String xmlFileName = FileLanguageTest.createFile(FILE_BODY, "/file/create/file-lang-txt-in", null, "in.xml");
        FileLanguageTest.startRouteAndWait("fileLanguage_txt");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/file/get/file-lang-txt-out/" + Paths.get(txtFileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(200)).body(IsEqual.equalTo((Object)FILE_BODY), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)("/file/get/file-lang-txt-out/" + Paths.get(xmlFileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void fileLanguageDate() throws UnsupportedEncodingException, InterruptedException {
        FileLanguageTest.createFile(FILE_BODY, "/file/create/file-lang-date-in", null, "in.xml");
        FileLanguageTest.startRouteAndWait("fileLanguage_date");
        SimpleDateFormat format = new SimpleDateFormat();
        format.applyPattern("yyyyMMdd");
        String fileName = "out-" + format.format(new Date()) + "-customValue.xml";
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/file/get/file-lang-date-out/" + Paths.get(fileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(200)).body(IsEqual.equalTo((Object)FILE_BODY), new Matcher[0]);
    }

    private static void startRouteAndWait(String routeId) throws InterruptedException {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(routeId).post("/file/startRoute", new Object[0])).then()).statusCode(204);
        Thread.sleep(500L);
    }

    private static String createFile(String content, String path, String charset, String prefix) throws UnsupportedEncodingException {
        if (charset == null) {
            charset = "UTF-8";
        }
        return FileLanguageTest.createFile(content.getBytes(charset), path, charset, prefix);
    }

    private static String createFile(byte[] content, String path, String charset, String fileName) {
        String createdFilePath = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().urlEncodingEnabled(true).queryParam("charset", new Object[]{charset}).contentType(ContentType.BINARY).body(content).queryParam("fileName", new Object[]{fileName}).post(path, new Object[0])).then()).statusCode(201)).extract().body().asString();
        return FileUtils.nixifyPath((String)createdFilePath);
    }
}

